/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.walker.ArchiveWalker;
import org.apache.rat.walker.DirectoryWalker;

public class Report {
    private static final String ADD = "A";
    private static final String ADD_OLD = "a";
    private static final String FORCE = "f";
    private static final String COPYRIGHT = "c";
    private static final String EXCLUDE_CLI = "e";
    private static final String EXCLUDE_FILE_CLI = "E";
    private static final String STYLESHEET_CLI = "s";
    private static final String HELP = "h";
    private static final String LICENSES = "licenses";
    private static final String NO_DEFAULTS = "no-default-licenses";
    private static final String SCAN_HIDDEN_DIRECTORIES = "scan-hidden-directories";
    private static final String LIST_LICENSES = "list-licenses";
    private static final String LIST_LICENSE_FAMILIES = "list-approved-families";
    private static final String XML = "x";
    private static final String LICENSE_FAMILY_FORMAT = "\t%s: %s\n";
    private static final String LICENSE_FORMAT = "%s:\t%s\n\t\t%s\n";

    public static void main(String[] args) throws Exception {
        CommandLine cl;
        Options opts = Report.buildOptions();
        try {
            cl = new DefaultParser().parse(opts, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println("Please use the \"--help\" option to see a list of valid commands and options");
            System.exit(1);
            return;
        }
        if (cl.hasOption(HELP)) {
            Report.printUsage(opts);
        }
        if ((args = cl.getArgs()) == null || args.length != 1) {
            Report.printUsage(opts);
        } else {
            ReportConfiguration configuration = Report.createConfiguration(args[0], cl);
            configuration.validate(System.err::println);
            if (cl.hasOption(LIST_LICENSE_FAMILIES)) {
                Report.listLicenseFamilies(configuration.getLicenseFamilies(LicenseSetFactory.LicenseFilter.all), System.out);
            }
            if (cl.hasOption(LIST_LICENSES)) {
                Report.listLicenses(configuration.getLicenses(LicenseSetFactory.LicenseFilter.all), System.out);
            }
            Reporter.report(configuration);
        }
    }

    static ReportConfiguration createConfiguration(String baseDirectory, CommandLine cl) throws IOException {
        String excludeFileName;
        String[] filter;
        ReportConfiguration configuration = new ReportConfiguration();
        if (cl.hasOption('o')) {
            configuration.setOut(new File(cl.getOptionValue('o')));
        }
        if (cl.hasOption(SCAN_HIDDEN_DIRECTORIES)) {
            configuration.setDirectoryFilter(null);
        }
        if (cl.hasOption('a') || cl.hasOption('A')) {
            configuration.setAddLicenseHeaders(cl.hasOption('f') ? AddLicenseHeaders.FORCED : AddLicenseHeaders.TRUE);
            configuration.setCopyrightMessage(cl.getOptionValue(COPYRIGHT));
        }
        if (cl.hasOption(EXCLUDE_CLI)) {
            String[] excludes = cl.getOptionValues(EXCLUDE_CLI);
            if (excludes != null) {
                filter = Report.parseExclusions(Arrays.asList(excludes));
                configuration.setInputFileFilter((FilenameFilter)filter);
            }
        } else if (cl.hasOption(EXCLUDE_FILE_CLI) && (excludeFileName = cl.getOptionValue(EXCLUDE_FILE_CLI)) != null) {
            filter = Report.parseExclusions(FileUtils.readLines(new File(excludeFileName), StandardCharsets.UTF_8));
            configuration.setInputFileFilter((FilenameFilter)filter);
        }
        if (cl.hasOption(XML)) {
            configuration.setStyleReport(false);
        } else {
            configuration.setStyleReport(true);
            if (cl.hasOption(STYLESHEET_CLI)) {
                String[] style = cl.getOptionValues(STYLESHEET_CLI);
                if (style.length != 1) {
                    System.err.println("please specify a single stylesheet");
                    System.exit(1);
                }
                configuration.setStyleSheet(() -> Files.newInputStream(Paths.get(style[0], new String[0]), new OpenOption[0]));
            }
        }
        Defaults.Builder defaultBuilder = Defaults.builder();
        if (cl.hasOption(NO_DEFAULTS)) {
            defaultBuilder.noDefault();
        }
        if (cl.hasOption(LICENSES)) {
            for (String fn : cl.getOptionValues(LICENSES)) {
                defaultBuilder.add(fn);
            }
        }
        Defaults defaults = defaultBuilder.build();
        configuration.setFrom(defaults);
        configuration.setReportable(Report.getDirectory(baseDirectory, configuration));
        return configuration;
    }

    private static void listLicenseFamilies(SortedSet<ILicenseFamily> families, PrintStream out) {
        out.println("Families:");
        families.forEach(x -> out.format(LICENSE_FAMILY_FORMAT, x.getFamilyCategory(), x.getFamilyName()));
        out.println();
    }

    private static void listLicenses(SortedSet<ILicense> licenses, PrintStream out) {
        out.println("Licenses:");
        licenses.forEach(lic -> out.format(LICENSE_FORMAT, lic.getLicenseFamily().getFamilyCategory(), lic.getLicenseFamily().getFamilyName(), lic.getNotes()));
        out.println();
    }

    static FilenameFilter parseExclusions(List<String> excludes) {
        OrFileFilter orFilter = new OrFileFilter();
        int ignoredLines = 0;
        for (String exclude : excludes) {
            try {
                if (exclude.startsWith("#") || StringUtils.isEmpty(exclude)) {
                    ++ignoredLines;
                    continue;
                }
                String exclusion = exclude.trim();
                orFilter.addFileFilter((IOFileFilter)new RegexFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)new NameFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)new WildcardFileFilter(exclusion));
            }
            catch (PatternSyntaxException e) {
                System.err.println("Will skip given exclusion '" + exclude + "' due to " + e);
            }
        }
        System.err.println("Ignored " + ignoredLines + " lines in your exclusion files as comments or empty lines.");
        return new NotFileFilter(orFilter);
    }

    static Options buildOptions() {
        Options opts = new Options();
        Option help = new Option(HELP, "help", false, "Print help for the RAT command line interface and exit");
        opts.addOption(help);
        Option out = new Option("o", "out", true, "Define the output file where to write report (default is System.out)");
        opts.addOption(out);
        String defaultHandlingText = " By default all approved default licenses are used";
        Option noDefaults = new Option(null, NO_DEFAULTS, false, "Ignore default configuration." + defaultHandlingText);
        opts.addOption(noDefaults);
        opts.addOption(null, LICENSES, true, "File names or URLs for license definitions");
        opts.addOption(null, LIST_LICENSES, false, "List all active licenses");
        opts.addOption(null, LIST_LICENSE_FAMILIES, false, "List all defined license families");
        opts.addOption(null, SCAN_HIDDEN_DIRECTORIES, false, "Scan hidden directories");
        OptionGroup addLicenseGroup = new OptionGroup();
        String addLicenseDesc = "Add the default license header to any file with an unknown license that is not in the exclusion list. By default new files will be created with the license header, to force the modification of existing files use the --force option.";
        Option addLicence = new Option(ADD_OLD, "addLicence", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicence);
        Option addLicense = new Option(ADD, "addLicense", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicense);
        opts.addOptionGroup(addLicenseGroup);
        Option write = new Option(FORCE, "force", false, "Forces any changes in files to be written directly to the source files (i.e. new files are not created)");
        opts.addOption(write);
        Option copyright = new Option(COPYRIGHT, "copyright", true, "The copyright message to use in the license headers, usually in the form of \"Copyright 2008 Foo\"");
        opts.addOption(copyright);
        Option exclude = Option.builder(EXCLUDE_CLI).argName("expression").longOpt("exclude").hasArgs().desc("Excludes files matching wildcard <expression>. Note that --dir is required when using this parameter. Allows multiple arguments.").build();
        opts.addOption(exclude);
        Option excludeFile = Option.builder(EXCLUDE_FILE_CLI).argName("fileName").longOpt("exclude-file").hasArgs().desc("Excludes files matching regular expression in <file> Note that --dir is required when using this parameter. ").build();
        opts.addOption(excludeFile);
        Option dir = new Option("d", "dir", false, "Used to indicate source when using --exclude");
        opts.addOption(dir);
        OptionGroup outputType = new OptionGroup();
        Option xml = new Option(XML, "xml", false, "Output the report in raw XML format.  Not compatible with -s");
        outputType.addOption(xml);
        Option xslt = new Option(STYLESHEET_CLI, "stylesheet", true, "XSLT stylesheet to use when creating the report.  Not compatible with -x");
        outputType.addOption(xslt);
        opts.addOptionGroup(outputType);
        return opts;
    }

    private static void printUsage(Options opts) {
        HelpFormatter f = new HelpFormatter();
        f.setOptionComparator(new OptionComparator());
        String header = "\nAvailable options";
        String footer = "\nNOTE:\nRat is really little more than a grep ATM\nRat is also rather memory hungry ATM\nRat is very basic ATM\nRat highlights possible issues\nRat reports require interpretation\nRat often requires some tuning before it runs well against a project\nRat relies on heuristics: it may miss issues\n";
        f.printHelp("java -jar apache-rat/target/apache-rat-CURRENT-VERSION.jar [options] [DIR|TARBALL]", header, opts, footer, false);
        System.exit(0);
    }

    private Report() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IReportable getDirectory(String baseDirectory, ReportConfiguration config) {
        try (PrintStream out = new PrintStream(config.getOutput().get());){
            File base = new File(baseDirectory);
            if (!base.exists()) {
                out.print("ERROR: ");
                out.print(baseDirectory);
                out.print(" does not exist.\n");
                IReportable iReportable = null;
                return iReportable;
            }
            if (base.isDirectory()) {
                DirectoryWalker directoryWalker = new DirectoryWalker(base, config.getInputFileFilter(), config.getDirectoryFilter());
                return directoryWalker;
            }
            ArchiveWalker archiveWalker = new ArchiveWalker(base, config.getInputFileFilter());
            return archiveWalker;
        }
        catch (IOException e) {
            throw new ConfigurationException("Error opening output", e);
        }
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        private String getKey(Option opt) {
            String key = opt.getOpt();
            key = key == null ? opt.getLongOpt() : key;
            return key;
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return this.getKey(opt1).compareToIgnoreCase(this.getKey(opt2));
        }
    }
}

