/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.junit.Assert;

abstract class AbstractFtpsProviderTestCase
extends AbstractProviderTestConfig {
    private static int SocketPort;
    private static String ConnectionUri;
    private static FtpServer Server;
    private static final String TEST_URI = "test.ftps.uri";
    private static final String USER_PROPS_RES = "org.apache.ftpsserver/users.properties";
    private static final String SERVER_JKS_RES = "org.apache.ftpsserver/ftpserver.jks";
    protected FileSystemOptions fileSystemOptions;

    AbstractFtpsProviderTestCase() {
    }

    static String getConnectionUri() {
        return ConnectionUri;
    }

    static int getSocketPort() {
        return SocketPort;
    }

    static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    static void setUpClass(boolean implicit) throws FtpException, IOException {
        if (Server != null) {
            return;
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        PropertiesUserManagerFactory propertiesUserManagerFactory = new PropertiesUserManagerFactory();
        URL userPropsResource = ClassLoader.getSystemClassLoader().getResource(USER_PROPS_RES);
        Assert.assertNotNull((String)USER_PROPS_RES, (Object)userPropsResource);
        propertiesUserManagerFactory.setUrl(userPropsResource);
        UserManager userManager = propertiesUserManagerFactory.createUserManager();
        BaseUser user = (BaseUser)userManager.getUserByName("test");
        user.setHomeDirectory(AbstractFtpsProviderTestCase.getTestDirectory());
        serverFactory.setUserManager(userManager);
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(0);
        URL serverJksResource = ClassLoader.getSystemClassLoader().getResource(SERVER_JKS_RES);
        Assert.assertNotNull((String)SERVER_JKS_RES, (Object)serverJksResource);
        SslConfigurationFactory ssl = new SslConfigurationFactory();
        File keyStoreFile = FileUtils.toFile((URL)serverJksResource);
        Assert.assertTrue((String)keyStoreFile.toString(), (boolean)keyStoreFile.exists());
        ssl.setKeystoreFile(keyStoreFile);
        ssl.setKeystorePassword("password");
        factory.setSslConfiguration(ssl.createSslConfiguration());
        factory.setImplicitSsl(implicit);
        serverFactory.addListener("default", factory.createListener());
        Server = serverFactory.createServer();
        Server.start();
        SocketPort = ((DefaultFtpServer)Server).getListener("default").getPort();
        ConnectionUri = "ftps://test:test@localhost:" + SocketPort;
    }

    static void tearDownClass() {
        if (Server != null) {
            Server.stop();
            Server = null;
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = AbstractFtpsProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        return manager.resolveFile(uri, this.getFileSystemOptions());
    }

    protected FileSystemOptions getFileSystemOptions() {
        if (this.fileSystemOptions == null) {
            this.fileSystemOptions = new FileSystemOptions();
            this.setupOptions(FtpsFileSystemConfigBuilder.getInstance());
        }
        return this.fileSystemOptions;
    }

    protected abstract boolean isImplicit();

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftps", (FileProvider)new FtpsFileProvider());
    }

    protected void setupOptions(FtpsFileSystemConfigBuilder builder) {
        builder.setConnectTimeout(this.fileSystemOptions, Duration.ofSeconds(1L));
        builder.setDataTimeout(this.fileSystemOptions, Duration.ofSeconds(2L));
    }

    static final class FtpProviderTestSuite
    extends ProviderTestSuite {
        private final boolean implicit;

        public FtpProviderTestSuite(AbstractFtpsProviderTestCase providerConfig) throws Exception {
            super(providerConfig);
            this.implicit = providerConfig.isImplicit();
        }

        @Override
        protected void setUp() throws Exception {
            if (AbstractFtpsProviderTestCase.getSystemTestUriOverride() == null) {
                AbstractFtpsProviderTestCase.setUpClass(this.implicit);
            }
            super.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            try {
                super.tearDown();
            }
            finally {
                AbstractFtpsProviderTestCase.tearDownClass();
            }
        }
    }
}

