/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.provider.UriParser;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UriParserTestCase {
    private static final String[] schemes = new String[2];

    @BeforeClass
    public static void setupSchemes() {
        UriParserTestCase.schemes[0] = "ftp";
        UriParserTestCase.schemes[1] = "file";
    }

    @Test
    public void testColonInFileName() {
        Assert.assertNull((Object)UriParser.extractScheme((String)"some/path/some:file"));
    }

    @Test
    public void testColonInFileNameAndNotSupportedScheme() {
        Assert.assertNull((Object)UriParser.extractScheme((String[])schemes, (String)"some:file"));
    }

    @Test
    public void testColonInFileNameWithPath() {
        Assert.assertNull((Object)UriParser.extractScheme((String[])schemes, (String)"some/path/some:file"));
    }

    @Test
    public void testColonNotFollowedBySlash() {
        Assert.assertEquals((Object)"file", (Object)UriParser.extractScheme((String[])schemes, (String)"file:user/subdir/some/path/some:file"));
    }

    @Test
    public void testNormalScheme() {
        Assert.assertEquals((Object)"ftp", (Object)UriParser.extractScheme((String[])schemes, (String)"ftp://user:pass@host/some/path/some:file"));
    }

    @Test
    public void testNormalSchemeWithBuffer() {
        StringBuilder buffer = new StringBuilder();
        UriParser.extractScheme((String[])schemes, (String)"ftp://user:pass@host/some/path/some:file", (StringBuilder)buffer);
        Assert.assertEquals((Object)"//user:pass@host/some/path/some:file", (Object)buffer.toString());
    }

    @Test
    public void testOneSlashScheme() {
        Assert.assertEquals((Object)"file", (Object)UriParser.extractScheme((String[])schemes, (String)"file:/user:pass@host/some/path/some:file"));
    }

    @Test
    public void testOneSlashSchemeWithBuffer() {
        StringBuilder buffer = new StringBuilder();
        UriParser.extractScheme((String[])schemes, (String)"file:/user:pass@host/some/path/some:file", (StringBuilder)buffer);
        Assert.assertEquals((Object)"/user:pass@host/some/path/some:file", (Object)buffer.toString());
    }
}

