/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.SizeFileFilter;
import org.apache.commons.vfs2.filter.SizeRangeFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SizeFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File minFile;
    private static FileSelectInfo minFileInfo;
    private static File optFile;
    private static FileSelectInfo optFileInfo;
    private static File maxFile;
    private static FileSelectInfo maxFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterClass
    public static void afterClass() throws IOException {
        minFileInfo = null;
        minFile = null;
        optFileInfo = null;
        optFile = null;
        maxFileInfo = null;
        maxFile = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = SizeFileFilterTest.getTestDir(SizeFileFilterTest.class.getName());
        minFile = new File(testDir, "min.txt");
        FileUtils.write((File)minFile, (CharSequence)"12");
        minFileInfo = SizeFileFilterTest.createFileSelectInfo(minFile);
        optFile = new File(testDir, "opt.txt");
        FileUtils.write((File)optFile, (CharSequence)"1234");
        optFileInfo = SizeFileFilterTest.createFileSelectInfo(optFile);
        maxFile = new File(testDir, "max.txt");
        FileUtils.write((File)maxFile, (CharSequence)"123456");
        maxFileInfo = SizeFileFilterTest.createFileSelectInfo(maxFile);
        zipFile = new File(SizeFileFilterTest.getTempDir(), SizeFileFilterTest.class.getName() + ".zip");
        SizeFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = SizeFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testSizeFileFilterLong() throws FileSystemException {
        SizeFileFilter testee = new SizeFileFilter(4L);
        Assert.assertFalse((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertTrue((boolean)testee.accept(maxFileInfo));
    }

    @Test
    public void testSizeFileFilterLongBoolean() throws FileSystemException {
        SizeFileFilter testee = new SizeFileFilter(4L, true);
        Assert.assertFalse((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeFileFilter(4L, false);
        Assert.assertTrue((boolean)testee.accept(minFileInfo));
        Assert.assertFalse((boolean)testee.accept(optFileInfo));
        Assert.assertFalse((boolean)testee.accept(maxFileInfo));
    }

    @Test
    public void testSizeFileFilterZipDir() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeFileFilter(4L, true)));
        this.assertContains(files, optFile.getName(), maxFile.getName());
        Assert.assertEquals((long)2L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeFileFilter(4L, false)));
        this.assertContains(files, minFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(2L, 6L)));
        this.assertContains(files, minFile.getName(), optFile.getName(), maxFile.getName());
        Assert.assertEquals((long)3L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(3L, 6L)));
        this.assertContains(files, optFile.getName(), maxFile.getName());
        Assert.assertEquals((long)2L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(2L, 5L)));
        this.assertContains(files, minFile.getName(), optFile.getName());
        Assert.assertEquals((long)2L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(3L, 5L)));
        this.assertContains(files, optFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(4L, 4L)));
        this.assertContains(files, optFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
    }

    @Test
    public void testSizeRangeFileFilter() throws FileSystemException {
        SizeRangeFileFilter testee = new SizeRangeFileFilter(2L, 6L);
        Assert.assertTrue((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(3L, 6L);
        Assert.assertFalse((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(2L, 5L);
        Assert.assertTrue((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertFalse((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(3L, 5L);
        Assert.assertFalse((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertFalse((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(4L, 4L);
        Assert.assertFalse((boolean)testee.accept(minFileInfo));
        Assert.assertTrue((boolean)testee.accept(optFileInfo));
        Assert.assertFalse((boolean)testee.accept(maxFileInfo));
    }
}

