/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.DirectoryFileFilter;
import org.apache.commons.vfs2.filter.FileFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectoryAndFileFilterTest
extends BaseFilterTest {
    private static final String FILE = "myfile.txt";
    private static final String DIR = "mydir";
    private static File testDir;
    private static File file;
    private static FileSelectInfo fileInfo;
    private static File dir;
    private static FileSelectInfo dirInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterClass
    public static void afterClass() throws IOException {
        file = null;
        fileInfo = null;
        dir = null;
        dirInfo = null;
        notExistingFileInfo = null;
        notExistingFile = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = DirectoryAndFileFilterTest.getTestDir(DirectoryAndFileFilterTest.class.getName());
        testDir.mkdir();
        dir = new File(testDir, DIR);
        dir.mkdir();
        dirInfo = DirectoryAndFileFilterTest.createFileSelectInfo(dir);
        file = new File(dir, FILE);
        FileUtils.touch((File)file);
        fileInfo = DirectoryAndFileFilterTest.createFileSelectInfo(file);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = DirectoryAndFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(DirectoryAndFileFilterTest.getTempDir(), DirectoryAndFileFilterTest.class.getName() + ".zip");
        DirectoryAndFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = DirectoryAndFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                return FileFileFilter.FILE.accept(fileInfo);
            }

            public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                return true;
            }
        });
        this.assertContains(files, FILE);
        Assert.assertEquals((long)1L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(DirectoryFileFilter.DIRECTORY));
        this.assertContains(files, DIR);
        Assert.assertEquals((long)1L, (long)files.length);
    }

    @Test
    public void testDirectoryFileFilter() throws FileSystemException {
        FileFilter testee = DirectoryFileFilter.DIRECTORY;
        Assert.assertTrue((boolean)testee.accept(dirInfo));
        Assert.assertFalse((boolean)testee.accept(fileInfo));
        Assert.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testFileFileFilter() throws FileSystemException {
        FileFilter testee = FileFileFilter.FILE;
        Assert.assertTrue((boolean)testee.accept(fileInfo));
        Assert.assertFalse((boolean)testee.accept(dirInfo));
        Assert.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }
}

