/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.junit.Assert;
import org.junit.Test;

public class FileObjectEscapeCharacterInPathTest {
    private static final String REL_PATH_GREAT = "src/test/resources/test-data/\u597d.txt";
    private static final String REL_PATH_SPACE = "src/test/resources/test-data/1 1.txt";
    public static final String TEST_FILE_CONTENT = "aaa";
    public static final String[] TEST_FILE_PATHS = new String[]{"src/test/resources/test-data/1 1.txt", "src/test/resources/test-data/\u597d.txt"};

    private static StandardFileSystemManager loadFileSystemManager() throws FileSystemException {
        StandardFileSystemManager fileSystemManager = new StandardFileSystemManager();
        fileSystemManager.setLogger(null);
        fileSystemManager.init();
        fileSystemManager.setBaseFile(SystemUtils.getUserDir());
        return fileSystemManager;
    }

    private static File toFile2(FileObject fileObject) throws FileSystemException {
        if (fileObject == null || !"file".equals(fileObject.getURL().getProtocol())) {
            return null;
        }
        return new File(fileObject.getName().getPathDecoded());
    }

    private void testProviderGetPath(String relPathStr) throws URISyntaxException {
        FileSystems.getDefault().provider().getPath(new URI(Paths.get(relPathStr, new String[0]).toAbsolutePath().toUri().toString()));
    }

    @Test
    public void testProviderGetPathGreat() throws URISyntaxException {
        this.testProviderGetPath(REL_PATH_GREAT);
    }

    @Test
    public void testProviderGetPathSpace() throws URISyntaxException {
        this.testProviderGetPath(REL_PATH_SPACE);
    }

    @Test
    public void testToFile() throws IOException {
        this.testToFile((FailableFunction<FileObject, File, IOException>)((FailableFunction)fileObject -> fileObject.getPath().toFile()));
    }

    private void testToFile(FailableFunction<FileObject, File, IOException> function) throws IOException {
        for (String testFilePath : TEST_FILE_PATHS) {
            try (StandardFileSystemManager fileSystemManager = FileObjectEscapeCharacterInPathTest.loadFileSystemManager();
                 FileObject fileObject = fileSystemManager.resolveFile(testFilePath);){
                Assert.assertNotNull((Object)fileObject);
                try (FileContent content = fileObject.getContent();
                     InputStream inputStream = content.getInputStream();){
                    Assert.assertEquals((Object)TEST_FILE_CONTENT, (Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                }
                File file = (File)function.apply((Object)fileObject);
                Assert.assertNotNull((Object)file);
                Assert.assertEquals((Object)TEST_FILE_CONTENT, (Object)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            }
        }
    }

    @Test
    public void testToFile2() throws IOException {
        this.testToFile((FailableFunction<FileObject, File, IOException>)((FailableFunction)FileObjectEscapeCharacterInPathTest::toFile2));
    }
}

