/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BigDecimalValidatorTest
extends AbstractNumberValidatorTest {
    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new BigDecimalValidator(false);
        this.strictValidator = new BigDecimalValidator();
        this.testPattern = "#,###.###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.234X"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new BigDecimal("1234.5");
        BigDecimal testNumber2 = new BigDecimal(".1");
        BigDecimal testNumber3 = new BigDecimal("12345.67899");
        this.testZero = new BigDecimal("0");
        this.validStrict = new String[]{"0", "1234.5", "1,234.5", ".1", "12345.678990"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, testNumber2, testNumber3};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testBigDecimalRangeMinMax() {
        BigDecimalValidator validator = new BigDecimalValidator(true, 0, true);
        BigDecimal number9 = new BigDecimal("9");
        BigDecimal number10 = new BigDecimal("10");
        BigDecimal number11 = new BigDecimal("11");
        BigDecimal number19 = new BigDecimal("19");
        BigDecimal number20 = new BigDecimal("20");
        BigDecimal number21 = new BigDecimal("21");
        float min = 10.0f;
        float max = 20.0f;
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10.0, 20.0), (String)"isInRange(A) < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10.0, 20.0), (String)"isInRange(A) = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10.0, 20.0), (String)"isInRange(A) in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10.0, 20.0), (String)"isInRange(A) = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10.0, 20.0), (String)"isInRange(A) > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10.0), (String)"minValue(A) < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10.0), (String)"minValue(A) = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10.0), (String)"minValue(A) > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20.0), (String)"maxValue(A) < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20.0), (String)"maxValue(A) = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20.0), (String)"maxValue(A) > max");
    }

    @Test
    public void testBigDecimalValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String xxxx = "XXXX";
        BigDecimal expected = new BigDecimal(12345);
        Assertions.assertEquals((Object)expected, (Object)BigDecimalValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Object)expected, (Object)BigDecimalValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale ");
        Assertions.assertEquals((Object)expected, (Object)BigDecimalValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Object)expected, (Object)BigDecimalValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)BigDecimalValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)BigDecimalValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)BigDecimalValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)BigDecimalValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)BigDecimalValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)BigDecimalValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale");
        Assertions.assertNull((Object)BigDecimalValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)BigDecimalValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)BigDecimalValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)BigDecimalValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)BigDecimalValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)BigDecimalValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

