/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.util.ValidatorUtils;

public class GenericValidatorImpl {
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";

    private static boolean isStringOrNull(Object o) {
        if (o == null) {
            return true;
        }
        return o instanceof String;
    }

    public static boolean validateByte(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isByte((String)value);
    }

    public static boolean validateDouble(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isDouble((String)value);
    }

    public static boolean validateEmail(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isEmail((String)value);
    }

    public static boolean validateFloat(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isFloat((String)value);
    }

    public static boolean validateInt(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isInt((String)value);
    }

    public static boolean validateLong(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isLong((String)value);
    }

    public static boolean validatePositive(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericTypeValidator.formatInt((String)value) > 0;
    }

    public static boolean validateRaiseException(Object bean, Field field) throws Exception {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if ("RUNTIME".equals(value)) {
            throw new RuntimeException("RUNTIME-EXCEPTION");
        }
        if ("CHECKED".equals(value)) {
            throw new Exception("CHECKED-EXCEPTION");
        }
        throw new ValidatorException("VALIDATOR-EXCEPTION");
    }

    public static boolean validateRequired(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return !GenericValidator.isBlankOrNull((String)value);
    }

    public static boolean validateRequiredIf(Object bean, Field field, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = GenericValidatorImpl.isStringOrNull(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            boolean this_required = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).contains("[") && key.contains("]")) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            String dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                this_required = dependVal == null || dependVal.isEmpty();
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                this_required = dependVal != null && !dependVal.isEmpty();
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                this_required = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && this_required : required || this_required;
            ++i;
        }
        if (required) {
            return value != null && !value.isEmpty();
        }
        return true;
    }

    public static boolean validateShort(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isShort((String)value);
    }
}

