/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCheckDigitTest {
    private static final String POSSIBLE_CHECK_DIGITS = "0123456789 ABCDEFHIJKLMNOPQRSTUVWXYZ\tabcdefghijklmnopqrstuvwxyz!@\u00a3$%^&*()_+";
    protected Log log = LogFactory.getLog(this.getClass());
    protected int checkDigitLth = 1;
    protected CheckDigit routine;
    protected String[] valid;
    protected String[] invalid = new String[]{"12345678A"};
    protected String zeroSum = "0000000000";
    protected String missingMessage = "Code is missing";

    protected String checkDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return "";
        }
        int start = code.length() - this.checkDigitLth;
        return code.substring(start);
    }

    protected String[] createInvalidCodes(String[] codes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String fullCode : codes) {
            String code = this.removeCheckDigit(fullCode);
            String check = this.checkDigit(fullCode);
            for (int j = 0; j < POSSIBLE_CHECK_DIGITS.length(); ++j) {
                String curr = POSSIBLE_CHECK_DIGITS.substring(j, j + 1);
                if (curr.equals(check)) continue;
                list.add(code + curr);
            }
        }
        return list.toArray(new String[0]);
    }

    protected String removeCheckDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return null;
        }
        return code.substring(0, code.length() - this.checkDigitLth);
    }

    @AfterEach
    protected void tearDown() {
        this.valid = null;
        this.routine = null;
    }

    @Test
    public void testCalculateInvalid() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testCalculateInvalid() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.invalid.length; ++i) {
            try {
                String actual;
                String expected;
                String code = this.invalid[i];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("   " + i + " Testing Invalid Check Digit, Code=[" + code + "]"));
                }
                if (!(expected = this.checkDigit(code)).equals(actual = this.routine.calculate(this.removeCheckDigit(code)))) continue;
                Assertions.fail((String)("Expected mismatch for " + code + " expected " + expected + " actual " + actual));
                continue;
            }
            catch (CheckDigitException e) {
                Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid "), (String)("Invalid Character[" + i + "]=" + e.getMessage()));
            }
        }
    }

    @Test
    public void testCalculateValid() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testCalculateValid() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.valid.length; ++i) {
            String code = this.removeCheckDigit(this.valid[i]);
            String expected = this.checkDigit(this.valid[i]);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("   " + i + " Testing Valid Check Digit, Code=[" + code + "] expected=[" + expected + "]"));
                }
                Assertions.assertEquals((Object)expected, (Object)this.routine.calculate(code), (String)("valid[" + i + "]: " + this.valid[i]));
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)("valid[" + i + "]=" + this.valid[i] + " threw " + e));
            }
        }
    }

    @Test
    public void testIsValidFalse() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testIsValidFalse() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.invalid.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Invalid Code=[" + this.invalid[i] + "]"));
            }
            Assertions.assertFalse((boolean)this.routine.isValid(this.invalid[i]), (String)("invalid[" + i + "]: " + this.invalid[i]));
        }
        String[] invalidCheckDigits = this.createInvalidCodes(this.valid);
        for (int i = 0; i < invalidCheckDigits.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Invalid Check Digit, Code=[" + invalidCheckDigits[i] + "]"));
            }
            Assertions.assertFalse((boolean)this.routine.isValid(invalidCheckDigits[i]), (String)("invalid check digit[" + i + "]: " + invalidCheckDigits[i]));
        }
    }

    @Test
    public void testIsValidTrue() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testIsValidTrue() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.valid.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Valid Code=[" + this.valid[i] + "]"));
            }
            Assertions.assertTrue((boolean)this.routine.isValid(this.valid[i]), (String)("valid[" + i + "]: " + this.valid[i]));
        }
    }

    @Test
    public void testMissingCode() {
        Assertions.assertFalse((boolean)this.routine.isValid(null), (String)"isValid() Null");
        Assertions.assertFalse((boolean)this.routine.isValid(""), (String)"isValid() Zero Length");
        Assertions.assertFalse((boolean)this.routine.isValid("9"), (String)"isValid() Length 1");
        try {
            this.routine.calculate(null);
            Assertions.fail((String)"calculate() Null - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)this.missingMessage, (Object)e.getMessage(), (String)"calculate() Null");
        }
        try {
            this.routine.calculate("");
            Assertions.fail((String)"calculate() Zero Length - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)this.missingMessage, (Object)e.getMessage(), (String)"calculate() Zero Length");
        }
    }

    @Test
    public void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.routine);
            oos.flush();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.routine.getClass().getName() + " error during serialization: " + e));
        }
        Object result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.routine.getClass().getName() + " error during deserialization: " + e));
        }
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testZeroSum() {
        Assertions.assertFalse((boolean)this.routine.isValid(this.zeroSum), (String)"isValid() Zero Sum");
        try {
            this.routine.calculate(this.zeroSum);
            Assertions.fail((String)"Zero Sum - expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Invalid code, sum is zero", (Object)e.getMessage(), (String)"isValid() Zero Sum");
        }
    }
}

