/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.TypeBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class GenericTypeValidatorTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "typeForm";
    protected static String ACTION = "byte";

    private Map<String, ?> localeTest(TypeBean info, Locale locale) throws ValidatorException {
        Validator validator = new Validator(this.resources, "typeLocaleForm");
        validator.setParameter("java.lang.Object", (Object)info);
        validator.setParameter("java.util.Locale", (Object)locale);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        Map hResultValues = results.getResultValueMap();
        Assertions.assertTrue((boolean)(hResultValues.get("byte") instanceof Byte), () -> "Expecting byte result to be an instance of Byte for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("short") instanceof Short), () -> "Expecting short result to be an instance of Short for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("integer") instanceof Integer), () -> "Expecting integer result to be an instance of Integer for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("long") instanceof Long), () -> "Expecting long result to be an instance of Long for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("float") instanceof Float), () -> "Expecting float result to be an instance of Float for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("double") instanceof Double), () -> "Expecting double result to be an instance of Double for locale: " + locale);
        Assertions.assertTrue((boolean)(hResultValues.get("date") instanceof Date), () -> "Expecting date result to be an instance of Date for locale: " + locale);
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            Assertions.assertNotNull(value, () -> "value ValidatorResults.getResultValueMap() should not be null for locale: " + locale);
        }
        return hResultValues;
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("GenericTypeValidatorTest-config.xml");
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testFRLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("-129");
        info.setInteger("1443");
        info.setLong("88000");
        info.setFloat("12,1555");
        info.setDouble("129,1551511111");
        info.setDate("21/12/2010");
        Map<String, ?> map = this.localeTest(info, Locale.FRENCH);
        Assertions.assertEquals((int)12, (int)((Float)map.get("float")).intValue(), (String)"float value not correct");
        Assertions.assertEquals((int)129, (int)((Double)map.get("double")).intValue(), (String)"double value not correct");
    }

    @Test
    public void testType() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555f");
        info.setDouble("129.1551511111d");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)info);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        Map hResultValues = results.getResultValueMap();
        Assertions.assertTrue((boolean)(hResultValues.get("byte") instanceof Byte), (String)"Expecting byte result to be an instance of Byte.");
        Assertions.assertTrue((boolean)(hResultValues.get("short") instanceof Short), (String)"Expecting short result to be an instance of Short.");
        Assertions.assertTrue((boolean)(hResultValues.get("integer") instanceof Integer), (String)"Expecting integer result to be an instance of Integer.");
        Assertions.assertTrue((boolean)(hResultValues.get("long") instanceof Long), (String)"Expecting long result to be an instance of Long.");
        Assertions.assertTrue((boolean)(hResultValues.get("float") instanceof Float), (String)"Expecting float result to be an instance of Float.");
        Assertions.assertTrue((boolean)(hResultValues.get("double") instanceof Double), (String)"Expecting double result to be an instance of Double.");
        for (String key : hResultValues.keySet()) {
            Object value = hResultValues.get(key);
            Assertions.assertNotNull(value, (String)"value ValidatorResults.getResultValueMap() should not be null.");
        }
    }

    @Test
    public void testUSLocale() throws ValidatorException {
        TypeBean info = new TypeBean();
        info.setByte("12");
        info.setShort("129");
        info.setInteger("-144");
        info.setLong("88000");
        info.setFloat("12.1555");
        info.setDouble("129.1551511111");
        info.setDate("12/21/2010");
        this.localeTest(info, Locale.US);
    }
}

