/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.CUSIPCheckDigit;

public class CUSIPCheckDigitTest
extends AbstractCheckDigitTest {
    private static String[] invalidCheckDigits = new String[]{"DUS0421CW", "DUS0421CN", "DUS0421CE"};
    private static String[] validCheckDigits = new String[]{"DUS0421C5"};

    public CUSIPCheckDigitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.routine = CUSIPCheckDigit.CUSIP_CHECK_DIGIT;
        this.valid = new String[]{"037833100", "931142103", "837649128", "392690QT3", "594918104", "86770G101", "Y8295N109", "G8572F100"};
        this.invalid = new String[]{"0378#3100"};
    }

    public void testVALIDATOR_336_InvalidCheckDigits() {
        for (int i = 0; i < invalidCheckDigits.length; ++i) {
            String invalidCheckDigit = invalidCheckDigits[i];
            CUSIPCheckDigitTest.assertFalse((String)("Should fail: " + invalidCheckDigit), (boolean)this.routine.isValid(invalidCheckDigit));
        }
    }

    public void testVALIDATOR_336_ValidCheckDigits() {
        for (int i = 0; i < validCheckDigits.length; ++i) {
            String validCheckDigit = validCheckDigits[i];
            CUSIPCheckDigitTest.assertTrue((String)("Should fail: " + validCheckDigit), (boolean)this.routine.isValid(validCheckDigit));
        }
    }
}

