/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.CheckDigitException;

public abstract class AbstractCheckDigitTest
extends TestCase {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected int checkDigitLth = 1;
    protected CheckDigit routine;
    protected String[] valid;
    protected String[] invalid = new String[]{"12345678A"};
    protected String zeroSum = "0000000000";
    protected String missingMessage = "Code is missing";
    private static final String POSSIBLE_CHECK_DIGITS = "0123456789 ABCDEFHIJKLMNOPQRSTUVWXYZ\tabcdefghijklmnopqrstuvwxyz!@\u00a3$%^&*()_+";

    public AbstractCheckDigitTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.valid = null;
        this.routine = null;
    }

    public void testIsValidTrue() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testIsValidTrue() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.valid.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Valid Code=[" + this.valid[i] + "]"));
            }
            AbstractCheckDigitTest.assertTrue((String)("valid[" + i + "]: " + this.valid[i]), (boolean)this.routine.isValid(this.valid[i]));
        }
    }

    public void testIsValidFalse() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testIsValidFalse() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.invalid.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Invalid Code=[" + this.invalid[i] + "]"));
            }
            AbstractCheckDigitTest.assertFalse((String)("invalid[" + i + "]: " + this.invalid[i]), (boolean)this.routine.isValid(this.invalid[i]));
        }
        String[] invalidCheckDigits = this.createInvalidCodes(this.valid);
        for (int i = 0; i < invalidCheckDigits.length; ++i) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("   " + i + " Testing Invalid Check Digit, Code=[" + invalidCheckDigits[i] + "]"));
            }
            AbstractCheckDigitTest.assertFalse((String)("invalid check digit[" + i + "]: " + invalidCheckDigits[i]), (boolean)this.routine.isValid(invalidCheckDigits[i]));
        }
    }

    public void testCalculateValid() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testCalculateValid() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.valid.length; ++i) {
            String code = this.removeCheckDigit(this.valid[i]);
            String expected = this.checkDigit(this.valid[i]);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("   " + i + " Testing Valid Check Digit, Code=[" + code + "] expected=[" + expected + "]"));
                }
                AbstractCheckDigitTest.assertEquals((String)("valid[" + i + "]: " + this.valid[i]), (String)expected, (String)this.routine.calculate(code));
                continue;
            }
            catch (Exception e) {
                AbstractCheckDigitTest.fail((String)("valid[" + i + "]=" + this.valid[i] + " threw " + e));
            }
        }
    }

    public void testCalculateInvalid() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("testCalculateInvalid() for " + this.routine.getClass().getName()));
        }
        for (int i = 0; i < this.invalid.length; ++i) {
            try {
                String actual;
                String expected;
                String code = this.invalid[i];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("   " + i + " Testing Invalid Check Digit, Code=[" + code + "]"));
                }
                if (!(expected = this.checkDigit(code)).equals(actual = this.routine.calculate(this.removeCheckDigit(code)))) continue;
                AbstractCheckDigitTest.fail((String)("Expected mismatch for " + code + " expected " + expected + " actual " + actual));
                continue;
            }
            catch (CheckDigitException e) {
                AbstractCheckDigitTest.assertTrue((String)("Invalid Character[" + i + "]=" + e.getMessage()), (boolean)e.getMessage().startsWith("Invalid "));
            }
        }
    }

    public void testMissingCode() {
        AbstractCheckDigitTest.assertFalse((String)"isValid() Null", (boolean)this.routine.isValid(null));
        AbstractCheckDigitTest.assertFalse((String)"isValid() Zero Length", (boolean)this.routine.isValid(""));
        AbstractCheckDigitTest.assertFalse((String)"isValid() Length 1", (boolean)this.routine.isValid("9"));
        try {
            this.routine.calculate(null);
            AbstractCheckDigitTest.fail((String)"calculate() Null - expected exception");
        }
        catch (Exception e) {
            AbstractCheckDigitTest.assertEquals((String)"calculate() Null", (String)this.missingMessage, (String)e.getMessage());
        }
        try {
            this.routine.calculate("");
            AbstractCheckDigitTest.fail((String)"calculate() Zero Length - expected exception");
        }
        catch (Exception e) {
            AbstractCheckDigitTest.assertEquals((String)"calculate() Zero Length", (String)this.missingMessage, (String)e.getMessage());
        }
    }

    public void testZeroSum() {
        AbstractCheckDigitTest.assertFalse((String)"isValid() Zero Sum", (boolean)this.routine.isValid(this.zeroSum));
        try {
            this.routine.calculate(this.zeroSum);
            AbstractCheckDigitTest.fail((String)"Zero Sum - expected exception");
        }
        catch (Exception e) {
            AbstractCheckDigitTest.assertEquals((String)"isValid() Zero Sum", (String)"Invalid code, sum is zero", (String)e.getMessage());
        }
    }

    public void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.routine);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            AbstractCheckDigitTest.fail((String)(this.routine.getClass().getName() + " error during serialization: " + e));
        }
        Object result = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            AbstractCheckDigitTest.fail((String)(this.routine.getClass().getName() + " error during deserialization: " + e));
        }
        AbstractCheckDigitTest.assertNotNull((Object)result);
    }

    protected String[] createInvalidCodes(String[] codes) {
        ArrayList<String> list = new ArrayList<String>();
        for (String fullCode : codes) {
            String code = this.removeCheckDigit(fullCode);
            String check = this.checkDigit(fullCode);
            for (int j = 0; j < POSSIBLE_CHECK_DIGITS.length(); ++j) {
                String curr = POSSIBLE_CHECK_DIGITS.substring(j, j + 1);
                if (curr.equals(check)) continue;
                list.add(code + curr);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected String removeCheckDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return null;
        }
        return code.substring(0, code.length() - this.checkDigitLth);
    }

    protected String checkDigit(String code) {
        if (code == null || code.length() <= this.checkDigitLth) {
            return "";
        }
        int start = code.length() - this.checkDigitLth;
        return code.substring(start);
    }
}

