/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.ISSNValidator;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.EAN13CheckDigit;

public class ISSNValidatorTest
extends TestCase {
    private static final ISSNValidator VALIDATOR = ISSNValidator.getInstance();
    private final String[] validFormat = new String[]{"ISSN 0317-8471", "1050-124X", "ISSN 1562-6865", "1063-7710", "1748-7188", "ISSN 0264-2875", "1750-0095", "1188-1534", "1911-1479", "ISSN 1911-1460", "0001-6772", "1365-201X", "0264-3596", "1144-875X"};
    private final String[] invalidFormat = new String[]{"", "   ", "ISBN 0317-8471", "'1050-124X", "ISSN1562-6865", "10637710", "1748-7188'", "ISSN  0264-2875", "1750 0095", "1188_1534", "1911-1478"};

    public ISSNValidatorTest(String name) {
        super(name);
    }

    public void testIsValidISSN() {
        for (String f : this.validFormat) {
            ISSNValidatorTest.assertTrue((String)f, (boolean)VALIDATOR.isValid(f));
        }
    }

    public void testNull() {
        ISSNValidatorTest.assertFalse((String)"isValid", (boolean)VALIDATOR.isValid(null));
    }

    public void testInvalid() {
        for (String f : this.invalidFormat) {
            ISSNValidatorTest.assertFalse((String)f, (boolean)VALIDATOR.isValid(f));
        }
    }

    public void testIsValidISSNConvertNull() {
        ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, "00"));
    }

    public void testIsValidISSNConvertSuffix() {
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, null));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, ""));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, "0"));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, "A"));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, "AA"));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ISSNValidatorTest.assertNull((Object)VALIDATOR.convertToEAN13(null, "999"));
            ISSNValidatorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsValidISSNConvert() {
        CheckDigit ean13cd = EAN13CheckDigit.EAN13_CHECK_DIGIT;
        Random r = new Random();
        for (String f : this.validFormat) {
            String suffix = String.format("%02d", r.nextInt(100));
            String ean13 = VALIDATOR.convertToEAN13(f, suffix);
            ISSNValidatorTest.assertTrue((String)ean13, (boolean)ean13cd.isValid(ean13));
        }
        ISSNValidatorTest.assertEquals((String)"9771144875007", (String)VALIDATOR.convertToEAN13("1144-875X", "00"));
        ISSNValidatorTest.assertEquals((String)"9770264359008", (String)VALIDATOR.convertToEAN13("0264-3596", "00"));
        ISSNValidatorTest.assertEquals((String)"9771234567003", (String)VALIDATOR.convertToEAN13("1234-5679", "00"));
    }

    public void testConversionErrors() {
        String input = null;
        try {
            input = "9780072129519";
            VALIDATOR.extractFromEAN13(input);
            ISSNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            input = "9791090636071";
            VALIDATOR.extractFromEAN13(input);
            ISSNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            input = "03178471";
            VALIDATOR.extractFromEAN13(input);
            ISSNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidCheckDigitEan13() {
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567001"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567002"));
        ISSNValidatorTest.assertNotNull((Object)VALIDATOR.extractFromEAN13("9771234567003"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567004"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567005"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567006"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567007"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567008"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567009"));
        ISSNValidatorTest.assertNull((Object)VALIDATOR.extractFromEAN13("9771234567000"));
    }

    public void testIsValidExtract() {
        ISSNValidatorTest.assertEquals((String)"12345679", (String)VALIDATOR.extractFromEAN13("9771234567003"));
        ISSNValidatorTest.assertEquals((String)"00014664", (String)VALIDATOR.extractFromEAN13("9770001466006"));
        ISSNValidatorTest.assertEquals((String)"03178471", (String)VALIDATOR.extractFromEAN13("9770317847001"));
        ISSNValidatorTest.assertEquals((String)"1144875X", (String)VALIDATOR.extractFromEAN13("9771144875007"));
    }
}

