/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.validator.routines.IBANValidator;
import org.apache.commons.validator.routines.checkdigit.IBANCheckDigit;
import org.junit.Assert;
import org.junit.Test;

public class IBANValidatorTest {
    private final String[] validIBANFormat = new String[]{"AD1200012030200359100100", "AE070331234567890123456", "AL47212110090000000235698741", "AT611904300234573201", "AZ21NABZ00000000137010001944", "BA391290079401028494", "BE68539007547034", "BG80BNBG96611020345678", "BH67BMAG00001299123456", "BR1800000000141455123924100C2", "BR1800360305000010009795493C1", "BR9700360305000010009795493P1", "BY13NBRB3600900000002Z00AB00", "CH9300762011623852957", "CR05015202001026284066", "CY17002001280000001200527600", "CZ6508000000192000145399", "CZ9455000000001011038930", "DE89370400440532013000", "DK5000400440116243", "DO28BAGR00000001212453611324", "EE382200221020145685", "EG380019000500000000263180002", "ES9121000418450200051332", "FI2112345600000785", "FI5542345670000081", "FO6264600001631634", "FR1420041010050500013M02606", "GB29NWBK60161331926819", "GE29NB0000000101904917", "GI75NWBK000000007099453", "GL8964710001000206", "GR1601101250000000012300695", "GT82TRAJ01020000001210029690", "HR1210010051863000160", "HU42117730161111101800000000", "IE29AIBK93115212345678", "IL620108000000099999999", "IQ98NBIQ850123456789012", "IS140159260076545510730339", "IT60X0542811101000000123456", "JO94CBJO0010000000000131000302", "KW81CBKU0000000000001234560101", "KZ86125KZT5004100100", "LB62099900000001001901229114", "LC55HEMM000100010012001200023015", "LI21088100002324013AA", "LT121000011101001000", "LU280019400644750000", "LV80BANK0000435195001", "MC5811222000010123456789030", "MD24AG000225100013104168", "ME25505000012345678951", "MK07250120000058984", "MR1300020001010000123456753", "MT84MALT011000012345MTLCAST001S", "MU17BOMM0101101030300200000MUR", "NL91ABNA0417164300", "NO9386011117947", "PK36SCBL0000001123456702", "PL61109010140000071219812874", "PS92PALS000000000400123456702", "PT50000201231234567890154", "QA58DOHB00001234567890ABCDEFG", "RO49AAAA1B31007593840000", "RS35260005601001611379", "SA0380000000608010167519", "SC18SSCB11010000000000001497USD", "SE4550000000058398257466", "SI56191000000123438", "SI56263300012039086", "SK3112000000198742637541", "SM86U0322509800000000270100", "ST68000100010051845310112", "SV62CENR00000000000000700025", "SV43ACAT00000000000000123123", "TL380080012345678910157", "TN5910006035183598478831", "TR330006100519786457841326", "UA213223130000026007233566001", "UA213996220000026007233566001", "VA59001123000012345678", "VG96VPVG0000012345678901", "XK051212012345678906"};
    private final String[] invalidIBANFormat = new String[]{"", "   ", "A", "AB", "FR1420041010050500013m02606", "MT84MALT011000012345mtlcast001s", "LI21088100002324013aa", "QA58DOHB00001234567890abcdefg", "RO49AAAA1b31007593840000", "LC62HEMM000100010012001200023015", "BY00NBRB3600000000000Z00AB00", "ST68000200010192194210112", "SV62CENR0000000000000700025"};
    private static final IBANValidator VALIDATOR = IBANValidator.getInstance();
    private static final String IBAN_PART = "(?:(\\d+)!([acn]))";
    private static final Pattern IBAN_PAT = Pattern.compile("([A-Z]{2})(?:(\\d+)!([acn]))(?:(\\d+)!([acn]))(?:(\\d+)!([acn]))(?:(\\d+)!([acn]))?(?:(\\d+)!([acn]))?(?:(\\d+)!([acn]))?(?:(\\d+)!([acn]))?");

    @Test
    public void testValid() {
        for (String f : this.validIBANFormat) {
            Assert.assertTrue((String)("Checksum fail: " + f), (boolean)IBANCheckDigit.IBAN_CHECK_DIGIT.isValid(f));
            Assert.assertTrue((String)("Missing validator: " + f), (boolean)VALIDATOR.hasValidator(f));
            Assert.assertTrue((String)f, (boolean)VALIDATOR.isValid(f));
        }
    }

    @Test
    public void testInValid() {
        for (String f : this.invalidIBANFormat) {
            Assert.assertFalse((String)f, (boolean)VALIDATOR.isValid(f));
        }
    }

    @Test
    public void testNull() {
        Assert.assertFalse((String)"isValid(null)", (boolean)VALIDATOR.isValid(null));
    }

    @Test
    public void testHasValidator() {
        Assert.assertTrue((String)"GB", (boolean)VALIDATOR.hasValidator("GB"));
        Assert.assertFalse((String)"gb", (boolean)VALIDATOR.hasValidator("gb"));
    }

    @Test
    public void testGetValidator() {
        Assert.assertNotNull((String)"GB", (Object)VALIDATOR.getValidator("GB"));
        Assert.assertNull((String)"gb", (Object)VALIDATOR.getValidator("gb"));
    }

    @Test(expected=IllegalStateException.class)
    public void testSetDefaultValidator1() {
        Assert.assertNotNull((Object)VALIDATOR.setValidator("GB", 15, "GB"));
    }

    @Test(expected=IllegalStateException.class)
    public void testSetDefaultValidator2() {
        Assert.assertNotNull((Object)VALIDATOR.setValidator("GB", -1, "GB"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValidatorLC() {
        IBANValidator validator = new IBANValidator();
        Assert.assertNotNull((Object)validator.setValidator("gb", 15, "GB"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValidatorLen7() {
        IBANValidator validator = new IBANValidator();
        Assert.assertNotNull((Object)validator.setValidator("GB", 7, "GB"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValidatorLen35() {
        IBANValidator validator = new IBANValidator();
        Assert.assertNotNull((Object)validator.setValidator("GB", 35, "GB"));
    }

    @Test
    public void testSetValidatorLen_1() {
        IBANValidator validator = new IBANValidator();
        Assert.assertNotNull((String)"should be present", (Object)validator.setValidator("GB", -1, ""));
        Assert.assertNull((String)"no longer present", (Object)validator.setValidator("GB", -1, ""));
    }

    @Test
    public void testSorted() {
        IBANValidator validator = new IBANValidator();
        IBANValidator.Validator[] vals = validator.getDefaultValidators();
        Assert.assertNotNull((Object)vals);
        for (int i = 1; i < vals.length; ++i) {
            if (vals[i].countryCode.compareTo(vals[i - 1].countryCode) > 0) continue;
            Assert.fail((String)("Not sorted: " + vals[i].countryCode + " <= " + vals[i - 1].countryCode));
        }
    }

    private static int checkIBAN(File file, IBANValidator val) throws Exception {
        CSVFormat format = CSVFormat.DEFAULT.withDelimiter('\t');
        InputStreamReader rdr = new InputStreamReader((InputStream)new FileInputStream(file), "ISO_8859_1");
        CSVParser p = new CSVParser((Reader)rdr, format);
        CSVRecord country = null;
        CSVRecord cc = null;
        CSVRecord structure = null;
        CSVRecord length = null;
        for (CSVRecord o : p) {
            String item = o.get(0);
            if ("Name of country".equals(item)) {
                country = o;
                continue;
            }
            if ("IBAN prefix country code (ISO 3166)".equals(item)) {
                cc = o;
                continue;
            }
            if ("IBAN structure".equals(item)) {
                structure = o;
                continue;
            }
            if (!"IBAN length".equals(item)) continue;
            length = o;
        }
        for (int i = 1; i < country.size(); ++i) {
            try {
                String newLength = length.get(i).split("!")[0];
                String newRE = IBANValidatorTest.fmtRE(structure.get(i), Integer.parseInt(newLength));
                IBANValidator.Validator valre = val.getValidator(cc.get(i));
                if (valre == null) {
                    System.out.println("// Missing entry:");
                    IBANValidatorTest.printEntry(cc.get(i), newLength, newRE, country.get(i));
                    continue;
                }
                String currentLength = Integer.toString(valre.lengthOfIBAN);
                String currentRE = valre.validator.toString().replaceAll("^.+?\\{(.+)}", "$1").replaceAll("\\\\d", "\\\\\\\\d");
                if (currentRE.equals(newRE) && currentLength.equals(newLength)) continue;
                System.out.println("// Expected: " + newRE + ", " + newLength + " Actual: " + currentRE + ", " + currentLength);
                IBANValidatorTest.printEntry(cc.get(i), newLength, newRE, country.get(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        p.close();
        return country.size();
    }

    private static void printEntry(String ccode, String length, String ib, String country) {
        String fmt = String.format("\"%s\"", ib);
        System.out.printf("            new Validator(\"%s\", %s, %-40s), // %s\n", ccode, length, fmt, country);
    }

    private static String formatToRE(String type, int len) {
        char ctype = type.charAt(0);
        switch (ctype) {
            case 'n': {
                return String.format("\\\\d{%d}", len);
            }
            case 'a': {
                return String.format("[A-Z]{%d}", len);
            }
            case 'c': {
                return String.format("[A-Z0-9]{%d}", len);
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }

    private static String fmtRE(String iban_pat, int iban_len) {
        Matcher m = IBAN_PAT.matcher(iban_pat);
        if (m.matches()) {
            StringBuilder sb = new StringBuilder();
            String cc = m.group(1);
            int totalLen = cc.length();
            sb.append(cc);
            int len = Integer.parseInt(m.group(2));
            String curType = m.group(3);
            for (int i = 4; i <= m.groupCount() && m.group(i) != null; i += 2) {
                int count = Integer.parseInt(m.group(i));
                String type = m.group(i + 1);
                if (type.equals(curType)) {
                    len += count;
                    continue;
                }
                sb.append(IBANValidatorTest.formatToRE(curType, len));
                totalLen += len;
                curType = type;
                len = count;
            }
            sb.append(IBANValidatorTest.formatToRE(curType, len));
            if (iban_len != (totalLen += len)) {
                throw new IllegalArgumentException("IBAN pattern " + iban_pat + " does not match length " + iban_len);
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Unexpected IBAN pattern " + iban_pat);
    }

    public static void main(String[] a) throws Exception {
        IBANValidator validator = new IBANValidator();
        File iban_tsv = new File("target", "iban-registry.tsv");
        int countries = 0;
        if (iban_tsv.canRead()) {
            countries = IBANValidatorTest.checkIBAN(iban_tsv, validator);
        } else {
            System.out.println("Please load the file " + iban_tsv.getCanonicalPath() + " from https://www.swift.com/standards/data-standards/iban");
        }
        System.out.println("Processed " + countries + " countries.");
    }
}

