/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.FloatValidator;

public class FloatValidatorTest
extends AbstractNumberValidatorTest {
    public FloatValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new FloatValidator(false, 0);
        this.strictValidator = new FloatValidator();
        this.testPattern = "#,###.#";
        this.max = Float.valueOf(Float.MAX_VALUE);
        this.maxPlusOne = this.max.doubleValue() * 10.0;
        this.min = Float.valueOf(-3.4028235E38f);
        this.minMinusOne = this.min.doubleValue() * 10.0;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = Float.valueOf(1234.5f);
        this.testZero = Float.valueOf(0.0f);
        this.validStrict = new String[]{"0", "1234.5", "1,234.5"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testFloatValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String localeVal = "12.345";
        String germanPatternVal = "1.23.45";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Float expected = Float.valueOf(12345.0f);
        FloatValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)FloatValidator.getInstance().validate(defaultVal));
        FloatValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)FloatValidator.getInstance().validate(localeVal, locale));
        FloatValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)FloatValidator.getInstance().validate(patternVal, pattern));
        FloatValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)FloatValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        FloatValidatorTest.assertTrue((String)"isValid(A) default", (boolean)FloatValidator.getInstance().isValid(defaultVal));
        FloatValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)FloatValidator.getInstance().isValid(localeVal, locale));
        FloatValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)FloatValidator.getInstance().isValid(patternVal, pattern));
        FloatValidatorTest.assertTrue((String)"isValid(A) both", (boolean)FloatValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        FloatValidatorTest.assertNull((String)"validate(B) default", (Object)FloatValidator.getInstance().validate(XXXX));
        FloatValidatorTest.assertNull((String)"validate(B) locale ", (Object)FloatValidator.getInstance().validate(XXXX, locale));
        FloatValidatorTest.assertNull((String)"validate(B) pattern", (Object)FloatValidator.getInstance().validate(XXXX, pattern));
        FloatValidatorTest.assertNull((String)"validate(B) both", (Object)FloatValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        FloatValidatorTest.assertFalse((String)"isValid(B) default", (boolean)FloatValidator.getInstance().isValid(XXXX));
        FloatValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)FloatValidator.getInstance().isValid(XXXX, locale));
        FloatValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)FloatValidator.getInstance().isValid(XXXX, pattern));
        FloatValidatorTest.assertFalse((String)"isValid(B) both", (boolean)FloatValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testFloatSmallestValues() {
        String pattern = "#.#################################################################";
        DecimalFormat fmt = new DecimalFormat(pattern);
        Float smallestPositive = Float.valueOf(Float.MIN_VALUE);
        String strSmallestPositive = fmt.format(smallestPositive);
        FloatValidatorTest.assertEquals((String)"Smallest +ve", (Object)smallestPositive, (Object)FloatValidator.getInstance().validate(strSmallestPositive, pattern));
        Float smallestNegative = Float.valueOf(-1.4E-45f);
        String strSmallestNegative = fmt.format(smallestNegative);
        FloatValidatorTest.assertEquals((String)"Smallest -ve", (Object)smallestNegative, (Object)FloatValidator.getInstance().validate(strSmallestNegative, pattern));
        Double tooSmallPositive = 1.4012984643248171E-46;
        String strTooSmallPositive = fmt.format(tooSmallPositive);
        FloatValidatorTest.assertFalse((String)"Too small +ve", (boolean)FloatValidator.getInstance().isValid(strTooSmallPositive, pattern));
        Double tooSmallNegative = tooSmallPositive * -1.0;
        String strTooSmallNegative = fmt.format(tooSmallNegative);
        FloatValidatorTest.assertFalse((String)"Too small -ve", (boolean)FloatValidator.getInstance().isValid(strTooSmallNegative, pattern));
    }

    public void testFloatRangeMinMax() {
        FloatValidator validator = (FloatValidator)this.strictValidator;
        Float number9 = validator.validate("9", "#");
        Float number10 = validator.validate("10", "#");
        Float number11 = validator.validate("11", "#");
        Float number19 = validator.validate("19", "#");
        Float number20 = validator.validate("20", "#");
        Float number21 = validator.validate("21", "#");
        FloatValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, 10.0f, 20.0f));
        FloatValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, 10.0f, 20.0f));
        FloatValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, 10.0f, 20.0f));
        FloatValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, 10.0f, 20.0f));
        FloatValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, 10.0f, 20.0f));
        FloatValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, 10.0f));
        FloatValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, 10.0f));
        FloatValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, 10.0f));
        FloatValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, 20.0f));
        FloatValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, 20.0f));
        FloatValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, 20.0f));
    }
}

