/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Var;
import org.xml.sax.SAXException;

public class VarTest
extends AbstractCommonTest {
    protected static String FORM_KEY = "testForm";
    protected static String ACTION = "byte";

    public VarTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("VarTest-config.xml");
    }

    protected void tearDown() {
    }

    public void testVars() {
        Form form = this.resources.getForm(Locale.getDefault(), FORM_KEY);
        Field field1 = form.getField("field-1");
        VarTest.assertNotNull((String)"field-1 is null.", (Object)field1);
        VarTest.assertEquals((String)"field-1 property is wrong", (String)"field-1", (String)field1.getProperty());
        Var var11 = field1.getVar("var-1-1");
        VarTest.assertNotNull((String)"var-1-1 is null.", (Object)var11);
        VarTest.assertEquals((String)"var-1-1 name is wrong", (String)"var-1-1", (String)var11.getName());
        VarTest.assertEquals((String)"var-1-1 value is wrong", (String)"value-1-1", (String)var11.getValue());
        VarTest.assertEquals((String)"var-1-1 jstype is wrong", (String)"jstype-1-1", (String)var11.getJsType());
        VarTest.assertFalse((String)"var-1-1 resource is true", (boolean)var11.isResource());
        VarTest.assertNull((String)"var-1-1 bundle is not null.", (Object)var11.getBundle());
        Field field2 = form.getField("field-2");
        VarTest.assertNotNull((String)"field-2 is null.", (Object)field2);
        VarTest.assertEquals((String)"field-2 property is wrong", (String)"field-2", (String)field2.getProperty());
        Var var21 = field2.getVar("var-2-1");
        VarTest.assertNotNull((String)"var-2-1 is null.", (Object)var21);
        VarTest.assertEquals((String)"var-2-1 name is wrong", (String)"var-2-1", (String)var21.getName());
        VarTest.assertEquals((String)"var-2-1 value is wrong", (String)"value-2-1", (String)var21.getValue());
        VarTest.assertEquals((String)"var-2-1 jstype is wrong", (String)"jstype-2-1", (String)var21.getJsType());
        VarTest.assertTrue((String)"var-2-1 resource is false", (boolean)var21.isResource());
        VarTest.assertEquals((String)"var-2-1 bundle is wrong", (String)"bundle-2-1", (String)var21.getBundle());
        Var var22 = field2.getVar("var-2-2");
        VarTest.assertNotNull((String)"var-2-2 is null.", (Object)var22);
        VarTest.assertEquals((String)"var-2-2 name is wrong", (String)"var-2-2", (String)var22.getName());
        VarTest.assertEquals((String)"var-2-2 value is wrong", (String)"value-2-2", (String)var22.getValue());
        VarTest.assertNull((String)"var-2-2 jstype is not null", (Object)var22.getJsType());
        VarTest.assertFalse((String)"var-2-2 resource is true", (boolean)var22.isResource());
        VarTest.assertEquals((String)"var-2-2 bundle is wrong", (String)"bundle-2-2", (String)var22.getBundle());
    }
}

