/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.FormSet;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.util.ValidatorUtils;

public class ValidatorTest
extends TestCase {
    public ValidatorTest(String name) {
        super(name);
    }

    public void testManualObject() {
        ValidatorResult result;
        ValidatorResults results;
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources(property, action);
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        try {
            results = validator.validate();
            ValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
            result = results.getValidatorResult(property);
            ValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
            ValidatorTest.assertTrue((String)("ValidatorResult does not contain '" + action + "' validator result."), (boolean)result.containsAction(action));
            ValidatorTest.assertTrue((String)"Validation of the date formatting has failed.", (boolean)result.isValid(action));
        }
        catch (Exception e) {
            ValidatorTest.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        bean.setDate("2/30/1999");
        try {
            results = validator.validate();
            ValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
            result = results.getValidatorResult(property);
            ValidatorTest.assertNotNull((String)"Results are null.", (Object)results);
            ValidatorTest.assertTrue((String)("ValidatorResult does not contain '" + action + "' validator result."), (boolean)result.containsAction(action));
            ValidatorTest.assertTrue((String)"Validation of the date formatting has passed when it should have failed.", (!result.isValid(action) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            ValidatorTest.fail((String)"An exception was thrown while calling Validator.validate()");
        }
    }

    public void testOnlyReturnErrors() throws ValidatorException {
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources(property, action);
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        ValidatorResults results = validator.validate();
        ValidatorTest.assertNotNull((Object)results);
        ValidatorTest.assertTrue((boolean)results.getPropertyNames().contains(property));
        validator.setOnlyReturnErrors(true);
        results = validator.validate();
        ValidatorTest.assertFalse((boolean)results.getPropertyNames().contains(property));
    }

    public void testOnlyValidateField() throws ValidatorException {
        String property = "date";
        String action = "date";
        ValidatorResources resources = this.setupDateResources(property, action);
        TestBean bean = new TestBean();
        bean.setDate("2/3/1999");
        Validator validator = new Validator(resources, "testForm", property);
        validator.setParameter("java.lang.Object", (Object)bean);
        ValidatorResults results = validator.validate();
        ValidatorTest.assertNotNull((Object)results);
        ValidatorTest.assertTrue((boolean)results.getPropertyNames().contains(property));
    }

    private ValidatorResources setupDateResources(String property, String action) {
        ValidatorResources resources = new ValidatorResources();
        ValidatorAction va = new ValidatorAction();
        va.setName(action);
        va.setClassname("org.apache.commons.validator.ValidatorTest");
        va.setMethod("formatDate");
        va.setMethodParams("java.lang.Object,org.apache.commons.validator.Field");
        FormSet fs = new FormSet();
        Form form = new Form();
        form.setName("testForm");
        Field field = new Field();
        field.setProperty(property);
        field.setDepends(action);
        form.addField(field);
        fs.addForm(form);
        resources.addValidatorAction(va);
        resources.addFormSet(fs);
        resources.process();
        return resources;
    }

    public void testManualBoolean() {
        ValidatorResources resources = new ValidatorResources();
        ValidatorAction va = new ValidatorAction();
        va.setName("capLetter");
        va.setClassname("org.apache.commons.validator.ValidatorTest");
        va.setMethod("isCapLetter");
        va.setMethodParams("java.lang.Object,org.apache.commons.validator.Field,java.util.List");
        FormSet fs = new FormSet();
        Form form = new Form();
        form.setName("testForm");
        Field field = new Field();
        field.setProperty("letter");
        field.setDepends("capLetter");
        form.addField(field);
        fs.addForm(form);
        resources.addValidatorAction(va);
        resources.addFormSet(fs);
        resources.process();
        ArrayList l = new ArrayList();
        TestBean bean = new TestBean();
        bean.setLetter("A");
        Validator validator = new Validator(resources, "testForm");
        validator.setParameter("java.lang.Object", (Object)bean);
        validator.setParameter("java.util.List", l);
        try {
            validator.validate();
        }
        catch (Exception e) {
            ValidatorTest.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        ValidatorTest.assertEquals((String)"Validation of the letter 'A'.", (int)0, (int)l.size());
        l.clear();
        bean.setLetter("AA");
        try {
            validator.validate();
        }
        catch (Exception e) {
            ValidatorTest.fail((String)"An exception was thrown while calling Validator.validate()");
        }
        ValidatorTest.assertEquals((String)"Validation of the letter 'AA'.", (int)1, (int)l.size());
    }

    public static boolean isCapLetter(Object bean, Field field, List<String> l) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (value != null && value.length() == 1) {
            if (value.charAt(0) >= 'A' && value.charAt(0) <= 'Z') {
                return true;
            }
            l.add("Error");
            return false;
        }
        l.add("Error");
        return false;
    }

    public static Date formatDate(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        Date date = null;
        try {
            DateFormat formatter = null;
            formatter = DateFormat.getDateInstance(3, Locale.US);
            formatter.setLenient(false);
            date = formatter.parse(value);
        }
        catch (ParseException e) {
            System.out.println("ValidatorTest.formatDate() - " + e.getMessage());
        }
        return date;
    }

    public class TestBean {
        private String letter = null;
        private String date = null;

        public String getLetter() {
            return this.letter;
        }

        public void setLetter(String letter) {
            this.letter = letter;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }
}

