/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorResources;
import org.xml.sax.SAXException;

public class RetrieveFormTest
extends TestCase {
    private ValidatorResources resources = null;
    private static final String FORM_PREFIX = "testForm_";
    private static final Locale CANADA_FRENCH_XXX = new Locale("fr", "CA", "XXX");

    public RetrieveFormTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        InputStream[] streams = new InputStream[]{((Object)((Object)this)).getClass().getResourceAsStream("RetrieveFormTest-config.xml")};
        this.resources = new ValidatorResources(streams);
        for (int i = 0; i < streams.length; ++i) {
            streams[i].close();
        }
    }

    public void testDefaultForm() {
        String formKey = "testForm_default";
        this.checkForm(Locale.US, formKey, "default");
        this.checkForm(Locale.FRENCH, formKey, "default");
        this.checkForm(Locale.FRANCE, formKey, "default");
        this.checkForm(Locale.CANADA, formKey, "default");
        this.checkForm(Locale.CANADA_FRENCH, formKey, "default");
        this.checkForm(CANADA_FRENCH_XXX, formKey, "default");
    }

    public void testLanguageForm() {
        String formKey = "testForm_language";
        this.checkForm(Locale.US, formKey, "default");
        this.checkForm(Locale.FRENCH, formKey, "fr");
        this.checkForm(Locale.FRANCE, formKey, "fr");
        this.checkForm(Locale.CANADA, formKey, "default");
        this.checkForm(Locale.CANADA_FRENCH, formKey, "fr");
        this.checkForm(CANADA_FRENCH_XXX, formKey, "fr");
    }

    public void testLanguageCountryForm() {
        String formKey = "testForm_language_country";
        this.checkForm(Locale.US, formKey, "default");
        this.checkForm(Locale.FRENCH, formKey, "fr");
        this.checkForm(Locale.FRANCE, formKey, "fr_FR");
        this.checkForm(Locale.CANADA, formKey, "default");
        this.checkForm(Locale.CANADA_FRENCH, formKey, "fr_CA");
        this.checkForm(CANADA_FRENCH_XXX, formKey, "fr_CA");
    }

    public void testLanguageCountryVariantForm() {
        String formKey = "testForm_language_country_variant";
        this.checkForm(Locale.US, formKey, "default");
        this.checkForm(Locale.FRENCH, formKey, "fr");
        this.checkForm(Locale.FRANCE, formKey, "fr_FR");
        this.checkForm(Locale.CANADA, formKey, "default");
        this.checkForm(Locale.CANADA_FRENCH, formKey, "fr_CA");
        this.checkForm(CANADA_FRENCH_XXX, formKey, "fr_CA_XXX");
    }

    public void testFormNotFound() {
        String formKey = "INVALID_NAME";
        this.checkFormNotFound(Locale.US, formKey);
        this.checkFormNotFound(Locale.FRENCH, formKey);
        this.checkFormNotFound(Locale.FRANCE, formKey);
        this.checkFormNotFound(Locale.CANADA, formKey);
        this.checkFormNotFound(Locale.CANADA_FRENCH, formKey);
        this.checkFormNotFound(CANADA_FRENCH_XXX, formKey);
    }

    private void checkForm(Locale locale, String formKey, String expectedVarValue) {
        Form testForm = this.resources.getForm(locale, formKey);
        RetrieveFormTest.assertNotNull((String)("Form '" + formKey + "' null for locale " + locale), (Object)testForm);
        Field testField = testForm.getField("testProperty");
        RetrieveFormTest.assertEquals((String)("Incorrect Form '" + formKey + "' for locale '" + locale + "'"), (String)expectedVarValue, (String)testField.getVarValue("localeVar"));
    }

    private void checkFormNotFound(Locale locale, String formKey) {
        Form testForm = this.resources.getForm(locale, formKey);
        RetrieveFormTest.assertNull((String)("Form '" + formKey + "' not null for locale " + locale), (Object)testForm);
    }
}

