/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;

public class ExtensionTest
extends TestCase {
    protected static String FORM_KEY = "nameForm";
    protected static String FORM_KEY2 = "nameForm2";
    protected static String CHECK_MSG_KEY = "nameForm.lastname.displayname";
    protected static String ACTION = "required";
    private ValidatorResources resources = null;

    public ExtensionTest(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        try (InputStream in = null;){
            in = ((Object)((Object)this)).getClass().getResourceAsStream("ExtensionTest-config.xml");
            this.resources = new ValidatorResources(in);
        }
    }

    protected void tearDown() {
    }

    public void testRequired() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredFirstNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredFirstName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredLastNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
    }

    public void testRequiredLastName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have failed."), (!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)lastNameResult.isValid(ACTION));
    }

    public void testRequiredName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)firstNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)firstNameResult.isValid(ACTION));
        ExtensionTest.assertNotNull((String)"Last Name ValidatorResult should not be null.", (Object)lastNameResult);
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult should contain the '" + ACTION + "' action."), (boolean)lastNameResult.containsAction(ACTION));
        ExtensionTest.assertTrue((String)("Last Name ValidatorResult for the '" + ACTION + "' action should have passed."), (boolean)lastNameResult.isValid(ACTION));
    }

    public void testOverrideRule() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY2);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        ExtensionTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        ExtensionTest.assertNotNull((String)"First Name ValidatorResult should not be null.", (Object)firstNameResult);
        ExtensionTest.assertTrue((String)("First Name ValidatorResult for the '" + ACTION + "' action should have '" + CHECK_MSG_KEY + " as a key."), (boolean)firstNameResult.field.getArg(0).getKey().equals(CHECK_MSG_KEY));
        ExtensionTest.assertNull((String)"Last Name ValidatorResult should be null.", (Object)lastNameResult);
    }

    public void testOrder() {
        Form form = this.resources.getForm(ValidatorResources.defaultLocale, FORM_KEY);
        Form form2 = this.resources.getForm(ValidatorResources.defaultLocale, FORM_KEY2);
        ExtensionTest.assertNotNull((String)(FORM_KEY + " is null."), (Object)form);
        ExtensionTest.assertTrue((String)("There should only be 2 fields in " + FORM_KEY), (form.getFields().size() == 2 ? 1 : 0) != 0);
        ExtensionTest.assertNotNull((String)(FORM_KEY2 + " is null."), (Object)form2);
        ExtensionTest.assertTrue((String)("There should only be 2 fields in " + FORM_KEY2), (form2.getFields().size() == 2 ? 1 : 0) != 0);
        Field fieldFirstName = (Field)form.getFields().get(0);
        Field fieldLastName = (Field)form.getFields().get(1);
        ExtensionTest.assertTrue((String)("firstName in " + FORM_KEY + " should be the first in the list"), (boolean)fieldFirstName.getKey().equals("firstName"));
        ExtensionTest.assertTrue((String)("lastName in " + FORM_KEY + " should be the first in the list"), (boolean)fieldLastName.getKey().equals("lastName"));
        fieldLastName = (Field)form2.getFields().get(0);
        fieldFirstName = (Field)form2.getFields().get(1);
        ExtensionTest.assertTrue((String)("firstName in " + FORM_KEY2 + " should be the first in the list"), (boolean)fieldFirstName.getKey().equals("firstName"));
        ExtensionTest.assertTrue((String)("lastName in " + FORM_KEY2 + " should be the first in the list"), (boolean)fieldLastName.getKey().equals("lastName"));
    }
}

