/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class LogNormalSampler
implements SharedStateContinuousSampler {
    private final double mu;
    private final double sigma;
    private final NormalizedGaussianSampler gaussian;

    public LogNormalSampler(NormalizedGaussianSampler gaussian, double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not strictly positive: " + sigma);
        }
        this.mu = mu;
        this.sigma = sigma;
        this.gaussian = gaussian;
    }

    private LogNormalSampler(UniformRandomProvider rng, LogNormalSampler source) {
        this.mu = source.mu;
        this.sigma = source.sigma;
        this.gaussian = InternalUtils.newNormalizedGaussianSampler(source.gaussian, rng);
    }

    @Override
    public double sample() {
        return Math.exp(this.mu + this.sigma * this.gaussian.sample());
    }

    public String toString() {
        return "Log-normal deviate [" + this.gaussian.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new LogNormalSampler(rng, this);
    }

    public static SharedStateContinuousSampler of(NormalizedGaussianSampler gaussian, double mu, double sigma) {
        return new LogNormalSampler(gaussian, mu, sigma);
    }
}

