/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class DiscreteUniformSampler
extends SamplerBase
implements SharedStateDiscreteSampler {
    private final SharedStateDiscreteSampler delegate;

    public DiscreteUniformSampler(UniformRandomProvider rng, int lower, int upper) {
        super(null);
        this.delegate = DiscreteUniformSampler.of(rng, lower, upper);
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return (SharedStateDiscreteSampler)this.delegate.withUniformRandomProvider(rng);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException(lower + " > " + upper);
        }
        if (upper == lower) {
            return new FixedDiscreteUniformSampler(lower);
        }
        if (lower == 0) {
            return DiscreteUniformSampler.createZeroBoundedSampler(rng, upper);
        }
        int range = upper - lower + 1;
        if (DiscreteUniformSampler.isPowerOf2(range)) {
            return new OffsetDiscreteUniformSampler(lower, new PowerOf2RangeDiscreteUniformSampler(rng, range));
        }
        if (range <= 0) {
            return new LargeRangeDiscreteUniformSampler(rng, lower, upper);
        }
        return new OffsetDiscreteUniformSampler(lower, new SmallRangeDiscreteUniformSampler(rng, range));
    }

    private static AbstractDiscreteUniformSampler createZeroBoundedSampler(UniformRandomProvider rng, int upper) {
        int range = upper + 1;
        return DiscreteUniformSampler.isPowerOf2(range) ? new PowerOf2RangeDiscreteUniformSampler(rng, range) : new SmallRangeDiscreteUniformSampler(rng, range);
    }

    private static boolean isPowerOf2(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    private static class OffsetDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int offset;
        private final SharedStateDiscreteSampler sampler;

        OffsetDiscreteUniformSampler(int offset, SharedStateDiscreteSampler sampler) {
            super(null);
            this.offset = offset;
            this.sampler = sampler;
        }

        @Override
        public int sample() {
            return this.offset + this.sampler.sample();
        }

        @Override
        public String toString() {
            return this.sampler.toString();
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new OffsetDiscreteUniformSampler(this.offset, (SharedStateDiscreteSampler)this.sampler.withUniformRandomProvider(rng));
        }
    }

    private static class LargeRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int lower;
        private final int upper;

        LargeRangeDiscreteUniformSampler(UniformRandomProvider rng, int lower, int upper) {
            super(rng);
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public int sample() {
            int r;
            while ((r = this.rng.nextInt()) < this.lower || r > this.upper) {
            }
            return r;
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LargeRangeDiscreteUniformSampler(rng, this.lower, this.upper);
        }
    }

    private static class SmallRangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final long n;
        private final long threshold;

        SmallRangeDiscreteUniformSampler(UniformRandomProvider rng, int range) {
            super(rng);
            this.n = (long)range & 0xFFFFFFFFL;
            this.threshold = 0x100000000L % this.n;
        }

        SmallRangeDiscreteUniformSampler(UniformRandomProvider rng, SmallRangeDiscreteUniformSampler source) {
            super(rng);
            this.n = source.n;
            this.threshold = source.threshold;
        }

        @Override
        public int sample() {
            long result;
            while (((result = this.n * ((long)this.rng.nextInt() & 0xFFFFFFFFL)) & 0xFFFFFFFFL) < this.threshold) {
            }
            return (int)(result >>> 32);
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new SmallRangeDiscreteUniformSampler(rng, this);
        }
    }

    private static class PowerOf2RangeDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int shift;

        PowerOf2RangeDiscreteUniformSampler(UniformRandomProvider rng, int range) {
            super(rng);
            this.shift = Integer.numberOfLeadingZeros(range) + 1;
        }

        PowerOf2RangeDiscreteUniformSampler(UniformRandomProvider rng, PowerOf2RangeDiscreteUniformSampler source) {
            super(rng);
            this.shift = source.shift;
        }

        @Override
        public int sample() {
            return this.rng.nextInt() >>> this.shift;
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new PowerOf2RangeDiscreteUniformSampler(rng, this);
        }
    }

    private static class FixedDiscreteUniformSampler
    extends AbstractDiscreteUniformSampler {
        private final int value;

        FixedDiscreteUniformSampler(int value) {
            super(null);
            this.value = value;
        }

        @Override
        public int sample() {
            return this.value;
        }

        @Override
        public String toString() {
            return "Uniform deviate [X=" + this.value + "]";
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return this;
        }
    }

    private static abstract class AbstractDiscreteUniformSampler
    implements SharedStateDiscreteSampler {
        protected final UniformRandomProvider rng;

        AbstractDiscreteUniformSampler(UniformRandomProvider rng) {
            this.rng = rng;
        }

        public String toString() {
            return "Uniform deviate [" + this.rng.toString() + "]";
        }
    }
}

