/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.simple.internal.ByteArray2IntArray;
import org.apache.commons.rng.simple.internal.ByteArray2LongArray;
import org.apache.commons.rng.simple.internal.Int2Long;
import org.apache.commons.rng.simple.internal.IntArray2Int;
import org.apache.commons.rng.simple.internal.IntArray2LongArray;
import org.apache.commons.rng.simple.internal.Long2Int;
import org.apache.commons.rng.simple.internal.Long2IntArray;
import org.apache.commons.rng.simple.internal.Long2LongArray;
import org.apache.commons.rng.simple.internal.LongArray2IntArray;
import org.apache.commons.rng.simple.internal.LongArray2Long;
import org.apache.commons.rng.simple.internal.SeedFactory;

public enum NativeSeedType {
    INT((Class)Integer.class, 4){

        @Override
        public Integer createSeed(int size) {
            return SeedFactory.createInt();
        }

        @Override
        protected Integer convert(Integer seed, int size) {
            return seed;
        }

        @Override
        protected Integer convert(Long seed, int size) {
            return LONG_TO_INT.convert(seed);
        }

        @Override
        protected Integer convert(int[] seed, int size) {
            return INT_ARRAY_TO_INT.convert(seed);
        }

        @Override
        protected Integer convert(long[] seed, int size) {
            return LONG_TO_INT.convert(LONG_ARRAY_TO_LONG.convert(seed));
        }

        @Override
        protected Integer convert(byte[] seed, int size) {
            return INT_ARRAY_TO_INT.convert(BYTE_ARRAY_TO_INT_ARRAY.convert(seed));
        }
    }
    ,
    LONG((Class)Long.class, 8){

        @Override
        public Long createSeed(int size) {
            return SeedFactory.createLong();
        }

        @Override
        protected Long convert(Integer seed, int size) {
            return INT_TO_LONG.convert(seed);
        }

        @Override
        protected Long convert(Long seed, int size) {
            return seed;
        }

        @Override
        protected Long convert(int[] seed, int size) {
            return INT_TO_LONG.convert(INT_ARRAY_TO_INT.convert(seed));
        }

        @Override
        protected Long convert(long[] seed, int size) {
            return LONG_ARRAY_TO_LONG.convert(seed);
        }

        @Override
        protected Long convert(byte[] seed, int size) {
            return LONG_ARRAY_TO_LONG.convert(BYTE_ARRAY_TO_LONG_ARRAY.convert(seed));
        }
    }
    ,
    INT_ARRAY((Class)int[].class, 4){

        public int[] createSeed(int size) {
            return SeedFactory.createIntArray(Math.min(size, 128));
        }

        protected int[] convert(Integer seed, int size) {
            return LONG_TO_INT_ARRAY.convert(INT_TO_LONG.convert(seed), size);
        }

        protected int[] convert(Long seed, int size) {
            return LONG_TO_INT_ARRAY.convert(seed, size);
        }

        protected int[] convert(int[] seed, int size) {
            return seed;
        }

        protected int[] convert(long[] seed, int size) {
            return LONG_ARRAY_TO_INT_ARRAY.convert(seed);
        }

        protected int[] convert(byte[] seed, int size) {
            return BYTE_ARRAY_TO_INT_ARRAY.convert(seed);
        }
    }
    ,
    LONG_ARRAY((Class)long[].class, 8){

        public long[] createSeed(int size) {
            return SeedFactory.createLongArray(Math.min(size, 128));
        }

        protected long[] convert(Integer seed, int size) {
            return LONG_TO_LONG_ARRAY.convert(INT_TO_LONG.convert(seed), size);
        }

        protected long[] convert(Long seed, int size) {
            return LONG_TO_LONG_ARRAY.convert(seed, size);
        }

        protected long[] convert(int[] seed, int size) {
            return INT_ARRAY_TO_LONG_ARRAY.convert(seed);
        }

        protected long[] convert(long[] seed, int size) {
            return seed;
        }

        protected long[] convert(byte[] seed, int size) {
            return BYTE_ARRAY_TO_LONG_ARRAY.convert(seed);
        }
    };

    private static final String UNRECOGNISED_SEED = "Unrecognized seed type: ";
    private static final int RANDOM_SEED_ARRAY_SIZE = 128;
    private static final Long2Int LONG_TO_INT;
    private static final Int2Long INT_TO_LONG;
    private static final Long2IntArray LONG_TO_INT_ARRAY;
    private static final Long2LongArray LONG_TO_LONG_ARRAY;
    private static final LongArray2Long LONG_ARRAY_TO_LONG;
    private static final IntArray2Int INT_ARRAY_TO_INT;
    private static final LongArray2IntArray LONG_ARRAY_TO_INT_ARRAY;
    private static final IntArray2LongArray INT_ARRAY_TO_LONG_ARRAY;
    private static final ByteArray2IntArray BYTE_ARRAY_TO_INT_ARRAY;
    private static final ByteArray2LongArray BYTE_ARRAY_TO_LONG_ARRAY;
    private final Class<?> type;
    private final int bytes;

    private NativeSeedType(Class<?> type, int bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getBytes() {
        return this.bytes;
    }

    public abstract Object createSeed(int var1);

    public Object convertSeed(Object seed, int size) {
        if (seed instanceof Integer) {
            return this.convert((Integer)seed, size);
        }
        if (seed instanceof Long) {
            return this.convert((Long)seed, size);
        }
        if (seed instanceof int[]) {
            return this.convert((int[])seed, size);
        }
        if (seed instanceof long[]) {
            return this.convert((long[])seed, size);
        }
        if (seed instanceof byte[]) {
            return this.convert((byte[])seed, size);
        }
        throw new UnsupportedOperationException(UNRECOGNISED_SEED + seed);
    }

    protected abstract Object convert(Integer var1, int var2);

    protected abstract Object convert(Long var1, int var2);

    protected abstract Object convert(int[] var1, int var2);

    protected abstract Object convert(long[] var1, int var2);

    protected abstract Object convert(byte[] var1, int var2);

    public static byte[] convertSeedToBytes(Object seed) {
        if (seed instanceof Integer) {
            return NumberFactory.makeByteArray((int)((Integer)seed));
        }
        if (seed instanceof Long) {
            return NumberFactory.makeByteArray((long)((Long)seed));
        }
        if (seed instanceof int[]) {
            return NumberFactory.makeByteArray((int[])((int[])seed));
        }
        if (seed instanceof long[]) {
            return NumberFactory.makeByteArray((long[])((long[])seed));
        }
        if (seed instanceof byte[]) {
            return (byte[])seed;
        }
        throw new UnsupportedOperationException(UNRECOGNISED_SEED + seed);
    }

    static {
        LONG_TO_INT = new Long2Int();
        INT_TO_LONG = new Int2Long();
        LONG_TO_INT_ARRAY = new Long2IntArray(0);
        LONG_TO_LONG_ARRAY = new Long2LongArray(0);
        LONG_ARRAY_TO_LONG = new LongArray2Long();
        INT_ARRAY_TO_INT = new IntArray2Int();
        LONG_ARRAY_TO_INT_ARRAY = new LongArray2IntArray();
        INT_ARRAY_TO_LONG_ARRAY = new IntArray2LongArray();
        BYTE_ARRAY_TO_INT_ARRAY = new ByteArray2IntArray();
        BYTE_ARRAY_TO_LONG_ARRAY = new ByteArray2LongArray();
    }
}

