/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.SharedStateLongSampler;

public abstract class UniformLongSampler
implements SharedStateLongSampler {
    protected final UniformRandomProvider rng;

    UniformLongSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    public String toString() {
        return "Uniform deviate [" + this.rng.toString() + "]";
    }

    @Override
    public abstract UniformLongSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static UniformLongSampler of(UniformRandomProvider rng, long lower, long upper) {
        if (lower > upper) {
            throw new IllegalArgumentException(lower + " > " + upper);
        }
        if (upper == lower) {
            return new FixedUniformLongSampler(lower);
        }
        if (lower == 0L) {
            return UniformLongSampler.createZeroBoundedSampler(rng, upper);
        }
        long range = upper - lower + 1L;
        if (UniformLongSampler.isPowerOf2(range)) {
            return new OffsetUniformLongSampler(lower, new PowerOf2RangeUniformLongSampler(rng, range));
        }
        if (range <= 0L) {
            return new LargeRangeUniformLongSampler(rng, lower, upper);
        }
        return new OffsetUniformLongSampler(lower, new SmallRangeUniformLongSampler(rng, range));
    }

    private static UniformLongSampler createZeroBoundedSampler(UniformRandomProvider rng, long upper) {
        long range = upper + 1L;
        return UniformLongSampler.isPowerOf2(range) ? new PowerOf2RangeUniformLongSampler(rng, range) : new SmallRangeUniformLongSampler(rng, range);
    }

    private static boolean isPowerOf2(long value) {
        return value != 0L && (value & value - 1L) == 0L;
    }

    private static class OffsetUniformLongSampler
    extends UniformLongSampler {
        private final long offset;
        private final UniformLongSampler sampler;

        OffsetUniformLongSampler(long offset, UniformLongSampler sampler) {
            super(null);
            this.offset = offset;
            this.sampler = sampler;
        }

        @Override
        public long sample() {
            return this.offset + this.sampler.sample();
        }

        @Override
        public String toString() {
            return this.sampler.toString();
        }

        @Override
        public UniformLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new OffsetUniformLongSampler(this.offset, this.sampler.withUniformRandomProvider(rng));
        }
    }

    private static class LargeRangeUniformLongSampler
    extends UniformLongSampler {
        private final long lower;
        private final long upper;

        LargeRangeUniformLongSampler(UniformRandomProvider rng, long lower, long upper) {
            super(rng);
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public long sample() {
            long r;
            while ((r = this.rng.nextLong()) < this.lower || r > this.upper) {
            }
            return r;
        }

        @Override
        public UniformLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LargeRangeUniformLongSampler(rng, this.lower, this.upper);
        }
    }

    private static class SmallRangeUniformLongSampler
    extends UniformLongSampler {
        private final long n;

        SmallRangeUniformLongSampler(UniformRandomProvider rng, long range) {
            super(rng);
            this.n = range;
        }

        @Override
        public long sample() {
            long val;
            long bits;
            while ((bits = this.rng.nextLong() >>> 1) - (val = bits % this.n) + (this.n - 1L) < 0L) {
            }
            return val;
        }

        @Override
        public UniformLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new SmallRangeUniformLongSampler(rng, this.n);
        }
    }

    private static class PowerOf2RangeUniformLongSampler
    extends UniformLongSampler {
        private final int shift;

        PowerOf2RangeUniformLongSampler(UniformRandomProvider rng, long range) {
            super(rng);
            this.shift = Long.numberOfLeadingZeros(range) + 1;
        }

        PowerOf2RangeUniformLongSampler(UniformRandomProvider rng, PowerOf2RangeUniformLongSampler source) {
            super(rng);
            this.shift = source.shift;
        }

        @Override
        public long sample() {
            return this.rng.nextLong() >>> this.shift;
        }

        @Override
        public UniformLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new PowerOf2RangeUniformLongSampler(rng, this);
        }
    }

    private static class FixedUniformLongSampler
    extends UniformLongSampler {
        private final long value;

        FixedUniformLongSampler(long value) {
            super(null);
            this.value = value;
        }

        @Override
        public long sample() {
            return this.value;
        }

        @Override
        public String toString() {
            return "Uniform deviate [X=" + this.value + "]";
        }

        @Override
        public UniformLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return this;
        }
    }
}

