/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.proxy.factory.util.MethodSignature;
import org.apache.commons.proxy.factory.util.ProxyClassGenerator;

public abstract class AbstractProxyClassGenerator
implements ProxyClassGenerator {
    public static Method[] getImplementationMethods(Class[] proxyClasses) {
        HashMap<MethodSignature, Method> signatureMethodMap = new HashMap<MethodSignature, Method>();
        HashSet<MethodSignature> finalizedSignatures = new HashSet<MethodSignature>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            Method[] methods = proxyInterface.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodSignature signature = new MethodSignature(methods[j]);
                if (Modifier.isFinal(methods[j].getModifiers())) {
                    finalizedSignatures.add(signature);
                    continue;
                }
                if (signatureMethodMap.containsKey(signature)) continue;
                signatureMethodMap.put(signature, methods[j]);
            }
        }
        Collection resultingMethods = signatureMethodMap.values();
        Iterator i = finalizedSignatures.iterator();
        while (i.hasNext()) {
            MethodSignature signature = (MethodSignature)i.next();
            resultingMethods.remove(signatureMethodMap.get(signature));
        }
        return resultingMethods.toArray(new Method[resultingMethods.size()]);
    }
}

