/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.core.ArithmeticUtils;

public final class BinomialCoefficient {
    private static final int MAX_M = 33;
    private static final int SMALL_N = 61;
    private static final int LIMIT_N = 66;

    private BinomialCoefficient() {
    }

    public static long value(int n, int k) {
        int m = BinomialCoefficient.checkBinomial(n, k);
        if (m == 0) {
            return 1L;
        }
        if (m == 1) {
            return n;
        }
        long result = 1L;
        if (n <= 61) {
            int i = n - m + 1;
            for (int j = 1; j <= m; ++j) {
                result = result * (long)i / (long)j;
                ++i;
            }
        } else if (n <= 66) {
            int i = n - m + 1;
            for (int j = 1; j <= m; ++j) {
                long d = ArithmeticUtils.gcd((int)i, (int)j);
                result = result / ((long)j / d) * ((long)i / d);
                ++i;
            }
        } else {
            if (m > 33) {
                throw new ArithmeticException(n + " choose " + k);
            }
            int i = n - m + 1;
            for (int j = 1; j <= m; ++j) {
                long d = ArithmeticUtils.gcd((int)i, (int)j);
                result = Math.multiplyExact(result / ((long)j / d), (long)i / d);
                ++i;
            }
        }
        return result;
    }

    static int checkBinomial(int n, int k) {
        int m = n - k;
        if ((n | k | m) < 0) {
            if (n < 0) {
                throw new CombinatoricsException("Number {0} is negative", n);
            }
            throw new CombinatoricsException("Number {0} is out of range [{1}, {2}]", k, 0, n);
        }
        return m < k ? m : k;
    }
}

