/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.linear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.linear.LinearConstraint;
import org.apache.commons.math4.legacy.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math4.legacy.optim.linear.Relationship;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.GoalType;
import org.apache.commons.numbers.core.Precision;

class SimplexTableau {
    private static final String NEGATIVE_VAR_COLUMN_LABEL = "x-";
    private static final long EXPN = 0x7FF0000000000000L;
    private static final long FRAC = -9218868437227405313L;
    private static final int MAX_IEEE_EXP = 2047;
    private static final int MIN_IEEE_EXP = 0;
    private static final int OFFSET_IEEE_EXP = 1023;
    private static final int IEEE_EXPONENT_SHIFT = 52;
    private final LinearObjectiveFunction f;
    private final List<LinearConstraint> constraints;
    private final boolean restrictToNonNegative;
    private final List<String> columnLabels = new ArrayList<String>();
    private Array2DRowRealMatrix tableau;
    private final int numDecisionVariables;
    private final int numSlackVariables;
    private int numArtificialVariables;
    private final double epsilon;
    private final int maxUlps;
    private int[] basicVariables;
    private int[] basicRows;
    private int[] variableExpChange;

    SimplexTableau(LinearObjectiveFunction f, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative, double epsilon) {
        this(f, constraints, goalType, restrictToNonNegative, epsilon, 10);
    }

    SimplexTableau(LinearObjectiveFunction f, Collection<LinearConstraint> constraints, GoalType goalType, boolean restrictToNonNegative, double epsilon, int maxUlps) throws DimensionMismatchException {
        this.checkDimensions(f, constraints);
        this.f = f;
        this.constraints = this.normalizeConstraints(constraints);
        this.restrictToNonNegative = restrictToNonNegative;
        this.epsilon = epsilon;
        this.maxUlps = maxUlps;
        this.numDecisionVariables = f.getCoefficients().getDimension() + (restrictToNonNegative ? 0 : 1);
        this.numSlackVariables = this.getConstraintTypeCounts(Relationship.LEQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.numArtificialVariables = this.getConstraintTypeCounts(Relationship.EQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.tableau = this.createTableau(goalType == GoalType.MAXIMIZE);
        this.initializeBasicVariables(this.getSlackVariableOffset());
        this.initializeColumnLabels();
    }

    private void checkDimensions(LinearObjectiveFunction objectiveFunction, Collection<LinearConstraint> c) {
        int dimension = objectiveFunction.getCoefficients().getDimension();
        for (LinearConstraint constraint : c) {
            int constraintDimension = constraint.getCoefficients().getDimension();
            if (constraintDimension == dimension) continue;
            throw new DimensionMismatchException(constraintDimension, dimension);
        }
    }

    protected void initializeColumnLabels() {
        int i;
        if (this.getNumObjectiveFunctions() == 2) {
            this.columnLabels.add("W");
        }
        this.columnLabels.add("Z");
        for (i = 0; i < this.getOriginalNumDecisionVariables(); ++i) {
            this.columnLabels.add("x" + i);
        }
        if (!this.restrictToNonNegative) {
            this.columnLabels.add(NEGATIVE_VAR_COLUMN_LABEL);
        }
        for (i = 0; i < this.getNumSlackVariables(); ++i) {
            this.columnLabels.add("s" + i);
        }
        for (i = 0; i < this.getNumArtificialVariables(); ++i) {
            this.columnLabels.add("a" + i);
        }
        this.columnLabels.add("RHS");
    }

    protected Array2DRowRealMatrix createTableau(boolean maximize) {
        double value;
        int width = this.numDecisionVariables + this.numSlackVariables + this.numArtificialVariables + this.getNumObjectiveFunctions() + 1;
        int height = this.constraints.size() + this.getNumObjectiveFunctions();
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(height, width);
        if (this.getNumObjectiveFunctions() == 2) {
            matrix.setEntry(0, 0, -1.0);
        }
        int zIndex = this.getNumObjectiveFunctions() == 1 ? 0 : 1;
        matrix.setEntry(zIndex, zIndex, maximize ? 1.0 : -1.0);
        double[][] scaled = new double[this.constraints.size() + 1][];
        RealVector objectiveCoefficients = maximize ? this.f.getCoefficients().mapMultiply(-1.0) : this.f.getCoefficients();
        scaled[0] = objectiveCoefficients.toArray();
        double[] scaledRhs = new double[this.constraints.size() + 1];
        scaledRhs[0] = value = maximize ? this.f.getConstantTerm() : -1.0 * this.f.getConstantTerm();
        for (int i = 0; i < this.constraints.size(); ++i) {
            LinearConstraint constraint = this.constraints.get(i);
            scaled[i + 1] = constraint.getCoefficients().toArray();
            scaledRhs[i + 1] = constraint.getValue();
        }
        this.variableExpChange = new int[scaled[0].length];
        this.scale(scaled, scaledRhs);
        this.copyArray(scaled[0], matrix.getDataRef()[zIndex]);
        matrix.setEntry(zIndex, width - 1, scaledRhs[0]);
        if (!this.restrictToNonNegative) {
            matrix.setEntry(zIndex, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(scaled[0]));
        }
        int slackVar = 0;
        int artificialVar = 0;
        for (int i = 0; i < this.constraints.size(); ++i) {
            LinearConstraint constraint = this.constraints.get(i);
            int row = this.getNumObjectiveFunctions() + i;
            this.copyArray(scaled[i + 1], matrix.getDataRef()[row]);
            if (!this.restrictToNonNegative) {
                matrix.setEntry(row, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(scaled[i + 1]));
            }
            matrix.setEntry(row, width - 1, scaledRhs[i + 1]);
            if (constraint.getRelationship() == Relationship.LEQ) {
                matrix.setEntry(row, this.getSlackVariableOffset() + slackVar++, 1.0);
            } else if (constraint.getRelationship() == Relationship.GEQ) {
                matrix.setEntry(row, this.getSlackVariableOffset() + slackVar++, -1.0);
            }
            if (constraint.getRelationship() != Relationship.EQ && constraint.getRelationship() != Relationship.GEQ) continue;
            matrix.setEntry(0, this.getArtificialVariableOffset() + artificialVar, 1.0);
            matrix.setEntry(row, this.getArtificialVariableOffset() + artificialVar++, 1.0);
            matrix.setRowVector(0, matrix.getRowVector(0).subtract(matrix.getRowVector(row)));
        }
        return matrix;
    }

    private void scale(double[][] scaled, double[] scaledRhs) {
        int expChange;
        int maxExp;
        int minExp;
        int i;
        for (i = 0; i < scaled.length; ++i) {
            minExp = 2048;
            maxExp = -1;
            double[] dArray = scaled[i];
            int n = dArray.length;
            for (int j = 0; j < n; ++j) {
                double d = dArray[j];
                if (d == 0.0) continue;
                int e = SimplexTableau.exponent(d);
                if (e < minExp) {
                    minExp = e;
                }
                if (e <= maxExp) continue;
                maxExp = e;
            }
            if (scaledRhs[i] != 0.0) {
                int e = SimplexTableau.exponent(scaledRhs[i]);
                if (e < minExp) {
                    minExp = e;
                }
                if (e > maxExp) {
                    maxExp = e;
                }
            }
            if ((expChange = this.computeExpChange(minExp, maxExp)) == 0) continue;
            scaledRhs[i] = SimplexTableau.updateExponent(scaledRhs[i], expChange);
            SimplexTableau.updateExponent(scaled[i], expChange);
        }
        for (i = 0; i < this.variableExpChange.length; ++i) {
            minExp = 2048;
            maxExp = -1;
            for (double[] coefficients : scaled) {
                double d = coefficients[i];
                if (d == 0.0) continue;
                int e = SimplexTableau.exponent(d);
                if (e < minExp) {
                    minExp = e;
                }
                if (e <= maxExp) continue;
                maxExp = e;
            }
            this.variableExpChange[i] = expChange = this.computeExpChange(minExp, maxExp);
            if (expChange == 0) continue;
            for (double[] coefficients : scaled) {
                coefficients[i] = SimplexTableau.updateExponent(coefficients[i], expChange);
            }
        }
    }

    private int computeExpChange(int minExp, int maxExp) {
        int expChange = 0;
        if (minExp <= 2047 && minExp > 1023) {
            expChange = 1023 - minExp;
        } else if (maxExp >= 0 && maxExp < 1023) {
            expChange = 1023 - maxExp;
        }
        return expChange;
    }

    private static void updateExponent(double[] dar, int exp) {
        for (int i = 0; i < dar.length; ++i) {
            dar[i] = SimplexTableau.updateExponent(dar[i], exp);
        }
    }

    private static int exponent(double d) {
        long bits = Double.doubleToLongBits(d);
        return (int)((bits & 0x7FF0000000000000L) >>> 52);
    }

    private static double updateExponent(double d, int exp) {
        if (d == 0.0 || exp == 0) {
            return d;
        }
        long bits = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(bits & 0x800FFFFFFFFFFFFFL | ((bits & 0x7FF0000000000000L) >>> 52) + (long)exp << 52);
    }

    public List<LinearConstraint> normalizeConstraints(Collection<LinearConstraint> originalConstraints) {
        ArrayList<LinearConstraint> normalized = new ArrayList<LinearConstraint>(originalConstraints.size());
        for (LinearConstraint constraint : originalConstraints) {
            normalized.add(this.normalize(constraint));
        }
        return normalized;
    }

    private LinearConstraint normalize(LinearConstraint constraint) {
        if (constraint.getValue() < 0.0) {
            return new LinearConstraint(constraint.getCoefficients().mapMultiply(-1.0), constraint.getRelationship().oppositeRelationship(), -1.0 * constraint.getValue());
        }
        return new LinearConstraint(constraint.getCoefficients(), constraint.getRelationship(), constraint.getValue());
    }

    protected final int getNumObjectiveFunctions() {
        return this.numArtificialVariables > 0 ? 2 : 1;
    }

    private int getConstraintTypeCounts(Relationship relationship) {
        int count = 0;
        for (LinearConstraint constraint : this.constraints) {
            if (constraint.getRelationship() != relationship) continue;
            ++count;
        }
        return count;
    }

    private static double getInvertedCoefficientSum(double[] coefficients) {
        double sum = 0.0;
        for (double coefficient : coefficients) {
            sum -= coefficient;
        }
        return sum;
    }

    protected Integer getBasicRow(int col) {
        int row = this.basicVariables[col];
        return row == -1 ? null : Integer.valueOf(row);
    }

    protected int getBasicVariable(int row) {
        return this.basicRows[row];
    }

    private void initializeBasicVariables(int startColumn) {
        this.basicVariables = new int[this.getWidth() - 1];
        this.basicRows = new int[this.getHeight()];
        Arrays.fill(this.basicVariables, -1);
        for (int i = startColumn; i < this.getWidth() - 1; ++i) {
            Integer row = this.findBasicRow(i);
            if (row == null) continue;
            this.basicVariables[i] = row;
            this.basicRows[row.intValue()] = i;
        }
    }

    private Integer findBasicRow(int col) {
        Integer row = null;
        for (int i = 0; i < this.getHeight(); ++i) {
            double entry = this.getEntry(i, col);
            if (Precision.equals((double)entry, (double)1.0, (int)this.maxUlps) && row == null) {
                row = i;
                continue;
            }
            if (Precision.equals((double)entry, (double)0.0, (int)this.maxUlps)) continue;
            return null;
        }
        return row;
    }

    protected void dropPhase1Objective() {
        int i;
        if (this.getNumObjectiveFunctions() == 1) {
            return;
        }
        TreeSet<Integer> columnsToDrop = new TreeSet<Integer>();
        columnsToDrop.add(0);
        for (i = this.getNumObjectiveFunctions(); i < this.getArtificialVariableOffset(); ++i) {
            double entry = this.getEntry(0, i);
            if (Precision.compareTo((double)entry, (double)0.0, (double)this.epsilon) <= 0) continue;
            columnsToDrop.add(i);
        }
        for (i = 0; i < this.getNumArtificialVariables(); ++i) {
            int col = i + this.getArtificialVariableOffset();
            if (this.getBasicRow(col) != null) continue;
            columnsToDrop.add(col);
        }
        double[][] matrix = new double[this.getHeight() - 1][this.getWidth() - columnsToDrop.size()];
        for (int i2 = 1; i2 < this.getHeight(); ++i2) {
            int col = 0;
            for (int j = 0; j < this.getWidth(); ++j) {
                if (columnsToDrop.contains(j)) continue;
                matrix[i2 - 1][col++] = this.getEntry(i2, j);
            }
        }
        Integer[] drop = columnsToDrop.toArray(new Integer[0]);
        for (int i3 = drop.length - 1; i3 >= 0; --i3) {
            this.columnLabels.remove(drop[i3]);
        }
        this.tableau = new Array2DRowRealMatrix(matrix);
        this.numArtificialVariables = 0;
        this.initializeBasicVariables(this.getNumObjectiveFunctions());
    }

    private void copyArray(double[] src, double[] dest) {
        System.arraycopy(src, 0, dest, this.getNumObjectiveFunctions(), src.length);
    }

    boolean isOptimal() {
        double[] objectiveFunctionRow = this.getRow(0);
        int end = this.getRhsOffset();
        for (int i = this.getNumObjectiveFunctions(); i < end; ++i) {
            double entry = objectiveFunctionRow[i];
            if (Precision.compareTo((double)entry, (double)0.0, (double)this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    protected PointValuePair getSolution() {
        int negativeVarColumn = this.columnLabels.indexOf(NEGATIVE_VAR_COLUMN_LABEL);
        Integer negativeVarBasicRow = negativeVarColumn > 0 ? this.getBasicRow(negativeVarColumn) : null;
        double mostNegative = negativeVarBasicRow == null ? 0.0 : this.getEntry(negativeVarBasicRow, this.getRhsOffset());
        HashSet<Integer> usedBasicRows = new HashSet<Integer>();
        double[] coefficients = new double[this.getOriginalNumDecisionVariables()];
        for (int i = 0; i < coefficients.length; ++i) {
            int colIndex = this.columnLabels.indexOf("x" + i);
            if (colIndex < 0) {
                coefficients[i] = 0.0;
                continue;
            }
            Integer basicRow = this.getBasicRow(colIndex);
            if (basicRow != null && basicRow == 0) {
                coefficients[i] = 0.0;
            } else if (usedBasicRows.contains(basicRow)) {
                coefficients[i] = 0.0 - (this.restrictToNonNegative ? 0.0 : mostNegative);
            } else {
                usedBasicRows.add(basicRow);
                coefficients[i] = (basicRow == null ? 0.0 : this.getEntry(basicRow, this.getRhsOffset())) - (this.restrictToNonNegative ? 0.0 : mostNegative);
            }
            coefficients[i] = SimplexTableau.updateExponent(coefficients[i], this.variableExpChange[i]);
        }
        return new PointValuePair(coefficients, this.f.value(coefficients));
    }

    protected void performRowOperations(int pivotCol, int pivotRow) {
        double pivotVal = this.getEntry(pivotRow, pivotCol);
        this.divideRow(pivotRow, pivotVal);
        for (int i = 0; i < this.getHeight(); ++i) {
            double multiplier;
            if (i == pivotRow || (multiplier = this.getEntry(i, pivotCol)) == 0.0) continue;
            this.subtractRow(i, pivotRow, multiplier);
        }
        int previousBasicVariable = this.getBasicVariable(pivotRow);
        this.basicVariables[previousBasicVariable] = -1;
        this.basicVariables[pivotCol] = pivotRow;
        this.basicRows[pivotRow] = pivotCol;
    }

    protected void divideRow(int dividendRowIndex, double divisor) {
        double[] dividendRow = this.getRow(dividendRowIndex);
        int j = 0;
        while (j < this.getWidth()) {
            int n = j++;
            dividendRow[n] = dividendRow[n] / divisor;
        }
    }

    protected void subtractRow(int minuendRowIndex, int subtrahendRowIndex, double multiplier) {
        double[] minuendRow = this.getRow(minuendRowIndex);
        double[] subtrahendRow = this.getRow(subtrahendRowIndex);
        for (int i = 0; i < this.getWidth(); ++i) {
            int n = i;
            minuendRow[n] = minuendRow[n] - subtrahendRow[i] * multiplier;
        }
    }

    protected final int getWidth() {
        return this.tableau.getColumnDimension();
    }

    protected final int getHeight() {
        return this.tableau.getRowDimension();
    }

    protected final double getEntry(int row, int column) {
        return this.tableau.getEntry(row, column);
    }

    protected final void setEntry(int row, int column, double value) {
        this.tableau.setEntry(row, column, value);
    }

    protected final int getSlackVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables;
    }

    protected final int getArtificialVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables + this.numSlackVariables;
    }

    protected final int getRhsOffset() {
        return this.getWidth() - 1;
    }

    protected final int getNumDecisionVariables() {
        return this.numDecisionVariables;
    }

    protected final int getOriginalNumDecisionVariables() {
        return this.f.getCoefficients().getDimension();
    }

    protected final int getNumSlackVariables() {
        return this.numSlackVariables;
    }

    protected final int getNumArtificialVariables() {
        return this.numArtificialVariables;
    }

    protected final double[] getRow(int row) {
        return this.tableau.getDataRef()[row];
    }

    protected final double[][] getData() {
        return this.tableau.getData();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SimplexTableau) {
            SimplexTableau rhs = (SimplexTableau)other;
            return this.restrictToNonNegative == rhs.restrictToNonNegative && this.numDecisionVariables == rhs.numDecisionVariables && this.numSlackVariables == rhs.numSlackVariables && this.numArtificialVariables == rhs.numArtificialVariables && this.epsilon == rhs.epsilon && this.maxUlps == rhs.maxUlps && this.f.equals(rhs.f) && this.constraints.equals(rhs.constraints) && this.tableau.equals(rhs.tableau);
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.restrictToNonNegative).hashCode() ^ this.numDecisionVariables ^ this.numSlackVariables ^ this.numArtificialVariables ^ Double.valueOf(this.epsilon).hashCode() ^ this.maxUlps ^ this.f.hashCode() ^ this.constraints.hashCode() ^ this.tableau.hashCode();
    }
}

