/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.inference;

import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.MathInternalError;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.OutOfRangeException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.stat.inference.AlternativeHypothesis;
import org.apache.commons.statistics.distribution.BinomialDistribution;

public class BinomialTest {
    public boolean binomialTest(int numberOfTrials, int numberOfSuccesses, double probability, AlternativeHypothesis alternativeHypothesis, double alpha) {
        double pValue = this.binomialTest(numberOfTrials, numberOfSuccesses, probability, alternativeHypothesis);
        return pValue < alpha;
    }

    public double binomialTest(int numberOfTrials, int numberOfSuccesses, double probability, AlternativeHypothesis alternativeHypothesis) {
        if (numberOfTrials < 0) {
            throw new NotPositiveException((Number)numberOfTrials);
        }
        if (numberOfSuccesses < 0) {
            throw new NotPositiveException((Number)numberOfSuccesses);
        }
        if (probability < 0.0 || probability > 1.0) {
            throw new OutOfRangeException((Number)probability, (Number)0, (Number)1);
        }
        if (numberOfTrials < numberOfSuccesses) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, new Object[]{numberOfTrials, numberOfSuccesses});
        }
        if (alternativeHypothesis == null) {
            throw new NullArgumentException();
        }
        BinomialDistribution distribution = BinomialDistribution.of((int)numberOfTrials, (double)probability);
        switch (alternativeHypothesis) {
            case GREATER_THAN: {
                return distribution.survivalProbability(numberOfSuccesses - 1);
            }
            case LESS_THAN: {
                return distribution.cumulativeProbability(numberOfSuccesses);
            }
            case TWO_SIDED: {
                int criticalValueLow = 0;
                int criticalValueHigh = numberOfTrials;
                double pTotal = 0.0;
                do {
                    double pHigh;
                    double pLow;
                    if ((pLow = distribution.probability(criticalValueLow)) == (pHigh = distribution.probability(criticalValueHigh))) {
                        pTotal = criticalValueLow == criticalValueHigh ? (pTotal += pLow) : (pTotal += 2.0 * Math.nextDown(pLow));
                        ++criticalValueLow;
                        --criticalValueHigh;
                        continue;
                    }
                    if (pLow < pHigh) {
                        pTotal += pLow;
                        ++criticalValueLow;
                        continue;
                    }
                    pTotal += pHigh;
                    --criticalValueHigh;
                } while (criticalValueLow <= numberOfSuccesses && criticalValueHigh >= numberOfSuccesses);
                return pTotal;
            }
        }
        throw new MathInternalError((Localizable)LocalizedFormats.OUT_OF_RANGE_SIMPLE, new Object[]{alternativeHypothesis, AlternativeHypothesis.TWO_SIDED, AlternativeHypothesis.LESS_THAN});
    }
}

