/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class UnencryptedSocketDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = false;
    private static final String UNENCRYPTED_SOCKET_TYPE = "UNENCRYPTED_SOCKET";
    private BugReporter bugReporter;

    public UnencryptedSocketDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getClassConstantOperand().equals("java/net/Socket") && this.getNameConstantOperand().equals("<init>")) {
            OpcodeStack.Item top;
            int hostIndex;
            int depth = this.stack.getStackDepth();
            String host = "remote host";
            if (depth != 0 && (hostIndex = this.getSigConstantOperand().equals("(Ljava/lang/String;I)V") ? 1 : (this.getSigConstantOperand().equals("(Ljava/lang/String;IZ)V") ? 2 : (this.getSigConstantOperand().equals("(Ljava/lang/String;ILjava/net/InetAddress;I)V") ? 3 : -1))) != -1 && (top = this.stack.getStackItem(hostIndex)).getConstant() != null) {
                host = (String)top.getConstant();
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, UNENCRYPTED_SOCKET_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(host));
        }
    }
}

