/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.TaintMethodConfig;
import java.io.IOException;
import java.util.regex.Pattern;

public class TaintMethodConfigWithArgumentsAndLocation
extends TaintMethodConfig {
    private static final Pattern methodWithStringConstantOrEnumPattern;
    private String location;

    public TaintMethodConfigWithArgumentsAndLocation() {
        super(true);
    }

    public static boolean accepts(String typeSignature, String config) {
        int pos = config.lastIndexOf(64);
        if (pos < 0) {
            return false;
        }
        config = config.substring(0, pos);
        return methodWithStringConstantOrEnumPattern.matcher(typeSignature).matches() && TaintMethodConfig.configPattern.matcher(config).matches();
    }

    @Override
    public TaintMethodConfigWithArgumentsAndLocation load(String taintConfig) throws IOException {
        if (taintConfig == null) {
            throw new NullPointerException("String is null");
        }
        if ((taintConfig = taintConfig.trim()).isEmpty()) {
            throw new IOException("No taint method config specified");
        }
        int locationPos = taintConfig.lastIndexOf(64);
        if (locationPos < 0) {
            throw new IOException("Bad format: @ expected");
        }
        this.location = taintConfig.substring(locationPos + 1).trim();
        taintConfig = taintConfig.substring(0, locationPos);
        super.load(taintConfig);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    static {
        String javaIdentifierRegex = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        String classNameRegex = javaIdentifierRegex + "(\\/" + javaIdentifierRegex + ")*";
        String methodRegex = "((" + javaIdentifierRegex + "(\\$extension)?)|(<init>))";
        String stringConstantRegex = "\"[^\"]*\"";
        String enumNameRegex = "[A-Z_]+";
        String methodArguments = "(" + stringConstantRegex + ",?|" + enumNameRegex + ",?)*";
        String methodWithStringConstantOrEnumRegex = classNameRegex + "\\." + methodRegex + "\\(" + methodArguments + "\\)";
        methodWithStringConstantOrEnumPattern = Pattern.compile(methodWithStringConstantOrEnumRegex);
    }
}

