/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.password.AbstractHardcodedPasswordEqualsDetector;
import edu.umd.cs.findbugs.BugReporter;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class HardcodedPasswordEqualsDetector
extends AbstractHardcodedPasswordEqualsDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private static final InvokeMatcherBuilder STRING_EQUALS_METHOD = InstructionDSL.invokeInstruction().atClass("java/lang/String").atMethod("equals").withArgs("(Ljava/lang/Object;)Z");

    public HardcodedPasswordEqualsDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        if (STRING_EQUALS_METHOD.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0, 1}, HARD_CODE_PASSWORD_TYPE);
        }
        return InjectionPoint.NONE;
    }
}

