/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.StackUtils;
import com.h3xstream.findsecbugs.common.TaintUtil;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.password.IntuitiveHardcodePasswordDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;

public abstract class AbstractHardcodedPasswordEqualsDetector
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final boolean DEBUG = false;

    protected AbstractHardcodedPasswordEqualsDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.registerVisitor(this);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint rightValue = (Taint)fact.getStackValue(offset);
        Taint leftValue = (Taint)fact.getStackValue(offset == 0 ? 1 : 0);
        boolean passwordVariableLeft = leftValue.isUnknown() && leftValue.hasTag(Taint.Tag.PASSWORD_VARIABLE);
        boolean passwordVariableRight = rightValue.isUnknown() && rightValue.hasTag(Taint.Tag.PASSWORD_VARIABLE);
        boolean valueHardcodedLeft = TaintUtil.isConstantValueAndNotEmpty(leftValue);
        boolean valueHardcodedRight = TaintUtil.isConstantValueAndNotEmpty(rightValue);
        if (passwordVariableLeft && valueHardcodedRight || passwordVariableRight && valueHardcodedLeft) {
            return 2;
        }
        return 5;
    }

    @Override
    public void visitInvoke(InvokeInstruction instruction, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) {
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitLoad(LoadInstruction instruction, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
        int index = instruction.getIndex();
        LocalVariableGen var = StackUtils.getLocalVariable(methodGen, index);
        if (var == null) {
            return;
        }
        String fieldName = var.getName();
        boolean isPasswordVariable = false;
        String fieldNameLower = fieldName.toLowerCase();
        for (String password : IntuitiveHardcodePasswordDetector.PASSWORD_WORDS) {
            if (!fieldNameLower.contains(password)) continue;
            isPasswordVariable = true;
        }
        if (!isPasswordVariable) {
            return;
        }
        Taint passwordValue = (Taint)frameType.getValue(index);
        passwordValue.addTag(Taint.Tag.PASSWORD_VARIABLE);
        if (numProduced <= 0) {
            return;
        }
        try {
            for (int indexStack = 0; indexStack < numProduced; ++indexStack) {
                Taint value = (Taint)frameType.getStackValue(indexStack);
                value.addTag(Taint.Tag.PASSWORD_VARIABLE);
            }
        }
        catch (DataflowAnalysisException dataflowAnalysisException) {
            // empty catch block
        }
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taint, int numProduced, ConstantPoolGen cpg) throws Exception {
    }
}

