/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xml;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;

public class XmlStreamReaderDetector
extends OpcodeStackDetector {
    private static final String XXE_XMLSTREAMREADER_TYPE = "XXE_XMLSTREAMREADER";
    private static final String PROPERTY_SUPPORT_DTD = "javax.xml.stream.supportDTD";
    private static final String PROPERTY_IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
    private final BugReporter bugReporter;

    public XmlStreamReaderDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 182) {
            return;
        }
        String fullClassName = this.getClassConstantOperand();
        String method = this.getNameConstantOperand();
        if (fullClassName.equals("javax/xml/stream/XMLInputFactory") && (method.equals("createXMLStreamReader") || method.equals("createXMLEventReader") || method.equals("createFilteredReader"))) {
            CFG cfg;
            ClassContext classCtx = this.getClassContext();
            ConstantPoolGen cpg = classCtx.getConstantPoolGen();
            try {
                cfg = classCtx.getCFG(this.getMethod());
            }
            catch (CFGBuilderException e) {
                AnalysisContext.logError((String)"Cannot get CFG", (Exception)((Object)e));
                return;
            }
            Iterator i = cfg.locationIterator();
            while (i.hasNext()) {
                GETSTATIC getstatic;
                Integer valueWrapped;
                LDC loadConst;
                InvokeInstruction invoke;
                Location location = (Location)i.next();
                Instruction inst = location.getHandle().getInstruction();
                if (!(inst instanceof INVOKEVIRTUAL) || !"setProperty".equals((invoke = (InvokeInstruction)inst).getMethodName(cpg)) || (loadConst = ByteCode.getPrevInstruction(location.getHandle(), LDC.class)) == null || !PROPERTY_SUPPORT_DTD.equals(loadConst.getValue(cpg)) && !PROPERTY_IS_SUPPORTING_EXTERNAL_ENTITIES.equals(loadConst.getValue(cpg))) continue;
                InstructionHandle prev1 = location.getHandle().getPrev();
                InstructionHandle prev2 = prev1.getPrev();
                if (!(InstructionDSL.invokeInstruction().atClass("java.lang.Boolean").atMethod("valueOf").matches(prev1.getInstruction(), cpg) ? prev2.getInstruction() instanceof ICONST && (valueWrapped = ByteCode.getConstantInt(prev2)) != null && valueWrapped.equals(0) : prev1.getInstruction() instanceof GETSTATIC && (getstatic = (GETSTATIC)prev1.getInstruction()).getClassType(cpg).getClassName().equals("java.lang.Boolean") && getstatic.getFieldName(cpg).equals("FALSE"))) continue;
                return;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_XMLSTREAMREADER_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

