/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis.extra;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;

public class PotentialValueTracker
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final InvokeMatcherBuilder PROPERTIES_GET_WITH_DEFAULT = InstructionDSL.invokeInstruction().atClass("java/util/Properties").atMethod("getProperty").withArgs("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
    private static final InvokeMatcherBuilder OPTIONAL_OR = InstructionDSL.invokeInstruction().atClass("com/google/common/base/Optional").atMethod("or").withArgs("(Ljava/lang/Object;)Ljava/lang/Object;");
    private static final InvokeMatcherBuilder HASHMAP_GET_WITH_DEFAULT = InstructionDSL.invokeInstruction().atClass("java/util/HashMap").atMethod("getOrDefault").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");

    public PotentialValueTracker(BugReporter bugReporter) {
        super(bugReporter);
        this.registerVisitor(this);
    }

    @Override
    public void visitInvoke(InvokeInstruction invoke, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) throws DataflowAnalysisException {
        Taint defaultVal;
        if ((PROPERTIES_GET_WITH_DEFAULT.matches((Instruction)invoke, cpg) || OPTIONAL_OR.matches((Instruction)invoke, cpg) || HASHMAP_GET_WITH_DEFAULT.matches((Instruction)invoke, cpg)) && (defaultVal = parameters.get(0)).getConstantValue() != null) {
            Taint value = (Taint)frameType.getTopValue();
            value.setPotentialValue(defaultVal.getConstantValue());
        }
    }

    @Override
    public void visitLoad(LoadInstruction load, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taintFrame, int numProduced, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }
}

