/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TaintConfigLoader {
    public void load(InputStream input, TaintConfigReceiver receiver) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            this.putFromLine(line, receiver);
        }
    }

    private void putFromLine(String line, TaintConfigReceiver receiver) throws IOException {
        if (line.startsWith("-")) {
            return;
        }
        String[] tuple = line.split("\\:");
        if (tuple.length != 2) {
            throw new IOException("Line format is not 'type signature:config info': " + line);
        }
        receiver.receiveTaintConfig(tuple[0].trim(), tuple[1]);
    }

    public static interface TaintConfigReceiver {
        public void receiveTaintConfig(String var1, String var2) throws IOException;
    }
}

