/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class ErrorMessageExposureDetector
extends OpcodeStackDetector {
    private static final String INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE_TYPE = "INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE";
    private BugReporter bugReporter;

    public ErrorMessageExposureDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182) {
            String fullClassName = this.getClassConstantOperand();
            String method = this.getNameConstantOperand();
            if (this.isVulnerableClassToPrint(fullClassName) && method.equals("printStackTrace")) {
                if (this.stack.getStackDepth() > 1) {
                    OpcodeStack.Item parameter = this.stack.getStackItem(0);
                    if (parameter.getSignature().equals("Ljava/io/PrintStream;") || parameter.getSignature().equals("Ljava/io/PrintWriter;")) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE_TYPE, 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }

    private boolean isVulnerableClassToPrint(String classConstantOperand) {
        switch (classConstantOperand) {
            case "java/lang/Throwable": 
            case "java/lang/Exception": 
            case "java/lang/Error": 
            case "java/io/FileNotFoundException": 
            case "java/sql/SQLException": 
            case "java/net/BindException": 
            case "java/util/ConcurrentModificationException": 
            case "javax/naming/InsufficientResourcesException": 
            case "java/util/MissingResourceException": 
            case "java/util/jar/JarException": 
            case "java/security/acl/NotOwnerException": 
            case "java/lang/OutOfMemoryError": 
            case "java/lang/StackOverflowError": {
                return true;
            }
        }
        return false;
    }
}

