/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.config;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class FirstPriorityConfigTestCase
extends TestCase {
    public static Test suite() throws Exception {
        Class<FirstPriorityConfigTestCase> thisClass = FirstPriorityConfigTestCase.class;
        PathableClassLoader dummy = new PathableClassLoader(null);
        dummy.useExplicitLoader("junit.", Test.class.getClassLoader());
        dummy.addLogicalLib("testclasses");
        dummy.addLogicalLib("commons-logging");
        String thisClassPath = thisClass.getName().replace('.', '/') + ".class";
        URL baseUrl = dummy.findResource(thisClassPath);
        PathableClassLoader containerLoader = new PathableClassLoader(null);
        containerLoader.useExplicitLoader("junit.", Test.class.getClassLoader());
        containerLoader.addLogicalLib("commons-logging");
        PathableClassLoader webappLoader = new PathableClassLoader(containerLoader);
        webappLoader.addLogicalLib("testclasses");
        URL pri20URL = new URL(baseUrl, "priority20/");
        webappLoader.addURL(pri20URL);
        URL pri10URL = new URL(baseUrl, "priority10/");
        webappLoader.addURL(pri10URL);
        Class<?> testClass = webappLoader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, webappLoader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testPriority() throws Exception {
        LogFactory instance = LogFactory.getFactory();
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader lfClassLoader = instance.getClass().getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        FirstPriorityConfigTestCase.assertEquals((Object)thisClassLoader, (Object)contextClassLoader);
        FirstPriorityConfigTestCase.assertEquals((Object)lfClassLoader, (Object)thisClassLoader.getParent());
        FirstPriorityConfigTestCase.assertEquals((String)PathableClassLoader.class.getName(), (String)lfClassLoader.getClass().getName());
        String id = (String)instance.getAttribute("configId");
        FirstPriorityConfigTestCase.assertEquals((String)"Correct config file loaded", (String)"priority20", (String)id);
    }
}

