/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.csrf;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Arrays;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SpringCsrfUnrestrictedRequestMappingDetector
implements Detector {
    private static final String SPRING_CSRF_UNRESTRICTED_REQUEST_MAPPING_TYPE = "SPRING_CSRF_UNRESTRICTED_REQUEST_MAPPING";
    private static final String REQUEST_MAPPING_ANNOTATION_TYPE = "Lorg/springframework/web/bind/annotation/RequestMapping;";
    private static final String METHOD_ANNOTATION_ATTRIBUTE_KEY = "method";
    private static final List<String> UNPROTECTED_HTTP_REQUEST_METHODS = Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS");
    private BugReporter bugReporter;

    public SpringCsrfUnrestrictedRequestMappingDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : javaClass.getMethods()) {
            if (!SpringCsrfUnrestrictedRequestMappingDetector.isVulnerable(method)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, SPRING_CSRF_UNRESTRICTED_REQUEST_MAPPING_TYPE, 1).addClassAndMethod(javaClass, method));
        }
    }

    public void report() {
    }

    private static boolean isVulnerable(Method method) {
        AnnotationEntry requestMappingAnnotation = SpringCsrfUnrestrictedRequestMappingDetector.findRequestMappingAnnotation(method);
        if (requestMappingAnnotation == null) {
            return false;
        }
        ElementValuePair methodAnnotationAttribute = SpringCsrfUnrestrictedRequestMappingDetector.findMethodAnnotationAttribute(requestMappingAnnotation);
        if (methodAnnotationAttribute == null) {
            return true;
        }
        ElementValue methodAnnotationAttributeValue = methodAnnotationAttribute.getValue();
        if (SpringCsrfUnrestrictedRequestMappingDetector.isEmptyArray(methodAnnotationAttributeValue)) {
            return true;
        }
        return SpringCsrfUnrestrictedRequestMappingDetector.isMixOfUnprotectedAndProtectedHttpRequestMethods(methodAnnotationAttributeValue);
    }

    private static AnnotationEntry findRequestMappingAnnotation(Method method) {
        for (AnnotationEntry annotationEntry : method.getAnnotationEntries()) {
            if (!REQUEST_MAPPING_ANNOTATION_TYPE.equals(annotationEntry.getAnnotationType())) continue;
            return annotationEntry;
        }
        return null;
    }

    private static ElementValuePair findMethodAnnotationAttribute(AnnotationEntry requestMappingAnnotation) {
        for (ElementValuePair elementValuePair : requestMappingAnnotation.getElementValuePairs()) {
            if (!METHOD_ANNOTATION_ATTRIBUTE_KEY.equals(elementValuePair.getNameString())) continue;
            return elementValuePair;
        }
        return null;
    }

    private static boolean isEmptyArray(ElementValue methodAnnotationAttributeValue) {
        if (!(methodAnnotationAttributeValue instanceof ArrayElementValue)) {
            return false;
        }
        ArrayElementValue arrayElementValue = (ArrayElementValue)methodAnnotationAttributeValue;
        return arrayElementValue.getElementValuesArraySize() == 0;
    }

    private static boolean isMixOfUnprotectedAndProtectedHttpRequestMethods(ElementValue methodAnnotationAttributeValue) {
        ElementValue[] elementValues;
        if (!(methodAnnotationAttributeValue instanceof ArrayElementValue)) {
            return false;
        }
        ArrayElementValue arrayElementValue = (ArrayElementValue)methodAnnotationAttributeValue;
        if (arrayElementValue.getElementValuesArraySize() <= 1) {
            return false;
        }
        boolean atLeastOneUnprotected = false;
        boolean atLeastOneProtected = false;
        for (ElementValue elementValue : elementValues = arrayElementValue.getElementValuesArray()) {
            if (UNPROTECTED_HTTP_REQUEST_METHODS.contains(elementValue.stringifyValue())) {
                atLeastOneUnprotected = true;
            } else {
                atLeastOneProtected = true;
            }
            if (!atLeastOneUnprotected || !atLeastOneProtected) continue;
            return true;
        }
        return false;
    }
}

