/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.xml;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.List;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;

public class XmlInjectionDetector
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final String XML_INJECTION_TYPE = "POTENTIAL_XML_INJECTION";
    private static final String[] STRING_CONCAT_CLASS = new String[]{"java/lang/StringBuilder", "java/lang/StringBuffer"};
    private static final InvokeMatcherBuilder STRINGBUILDER_APPEND = InstructionDSL.invokeInstruction().atClass(STRING_CONCAT_CLASS).atMethod("append");
    private static final boolean DEBUG = false;

    public XmlInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
        for (String variant : STRING_CONCAT_CLASS) {
            this.addParsedInjectionPoint(variant + ".append(Ljava/lang/String;)L" + variant + ";", new InjectionPoint(new int[]{0}, XML_INJECTION_TYPE));
        }
        this.registerVisitor(this);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame taintFrame, int offset) throws DataflowAnalysisException {
        Taint taint0 = (Taint)taintFrame.getStackValue(0);
        Taint taint1 = (Taint)taintFrame.getStackValue(1);
        if (!taint0.isSafe() && !taint0.hasTag(Taint.Tag.XSS_SAFE) && taint1.hasTag(Taint.Tag.XML_VALUE)) {
            return 2;
        }
        return 5;
    }

    @Override
    public void visitInvoke(InvokeInstruction invoke, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) throws DataflowAnalysisException {
        Taint appendedTaint;
        String appendedString;
        if (STRINGBUILDER_APPEND.matches((Instruction)invoke, cpg) && (appendedString = (appendedTaint = parameters.get(0)).getConstantValue()) != null && appendedString.contains("<") && appendedString.contains(">")) {
            appendedTaint.addTag(Taint.Tag.XML_VALUE);
            ((Taint)frameType.getStackValue(0)).addTag(Taint.Tag.XML_VALUE);
        }
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitLoad(LoadInstruction instruction, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taint, int numProduced, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public boolean shouldAnalyzeClass(ClassContext classContext) {
        ConstantPoolGen constantPoolGen = classContext.getConstantPoolGen();
        boolean stringConcat = false;
        boolean hasOpenTagInString = false;
        for (String requiredClass : STRING_CONCAT_CLASS) {
            if (constantPoolGen.lookupUtf8(requiredClass) == -1) continue;
            stringConcat = true;
            break;
        }
        for (int i = 0; i < constantPoolGen.getSize(); ++i) {
            ConstantUtf8 utf8value;
            Constant c = constantPoolGen.getConstant(i);
            if (!(c instanceof ConstantUtf8) || !(utf8value = (ConstantUtf8)c).getBytes().contains("<")) continue;
            hasOpenTagInString = true;
            break;
        }
        return stringConcat && hasOpenTagInString;
    }
}

