/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.UserClass;

public class LoadTestCase
extends TestCase {
    private static String[] LOG_PCKG = new String[]{"org.apache.commons.logging", "org.apache.commons.logging.impl"};
    private ClassLoader origContextClassLoader;

    private void execute(Class cls) throws Exception {
        cls.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Class reload() throws Exception {
        Class testObjCls = null;
        AppClassLoader appLoader = new AppClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            testObjCls = appLoader.loadClass(UserClass.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Throwable t) {
            t.printStackTrace();
            LoadTestCase.fail((String)"AppClassLoader failed ");
        }
        LoadTestCase.assertSame((String)"app isolated", (Object)testObjCls.getClassLoader(), (Object)appLoader);
        return testObjCls;
    }

    private void setAllowFlawedContext(Class<?> c, String state) throws Exception {
        Class[] params = new Class[]{String.class};
        Method m = c.getDeclaredMethod("setAllowFlawedContext", params);
        m.invoke(null, state);
    }

    public void setUp() {
        this.origContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.origContextClassLoader);
    }

    public void testInContainer() throws Exception {
        block5: {
            Throwable targetException;
            Class cls;
            block4: {
                cls = this.reload();
                Thread.currentThread().setContextClassLoader(cls.getClassLoader());
                this.execute(cls);
                cls = this.reload();
                Thread.currentThread().setContextClassLoader(null);
                this.execute(cls);
                cls = this.reload();
                Thread.currentThread().setContextClassLoader(null);
                try {
                    this.setAllowFlawedContext(cls, "false");
                    this.execute(cls);
                    LoadTestCase.fail((String)"Logging config succeeded when context class loader was null!");
                }
                catch (InvocationTargetException ex) {
                    targetException = ex.getTargetException();
                    if (targetException instanceof LogConfigurationException) break block4;
                    throw ex;
                }
            }
            cls = this.reload();
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            this.execute(cls);
            cls = this.reload();
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            try {
                this.setAllowFlawedContext(cls, "false");
                this.execute(cls);
                LoadTestCase.fail((String)"Error: somehow downcast a Logger loaded via system class loader to the Log interface loaded via a custom class loader");
            }
            catch (InvocationTargetException ex) {
                targetException = ex.getTargetException();
                if (targetException instanceof LogConfigurationException) break block5;
                throw ex;
            }
        }
    }

    static class AppClassLoader
    extends ClassLoader {
        Map classes = new HashMap();

        AppClassLoader(ClassLoader parent) {
            super(parent);
        }

        private Class<?> def(String name) throws ClassNotFoundException {
            Class<?> result = (Class<?>)this.classes.get(name);
            if (result != null) {
                return result;
            }
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                String classFileName = name.replace('.', '/') + ".class";
                InputStream is = cl.getResourceAsStream(classFileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while (is.available() > 0) {
                    out.write(is.read());
                }
                byte[] data = out.toByteArray();
                result = super.defineClass(name, data, 0, data.length);
                this.classes.put(name, result);
                return result;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(name + " caused by " + ioe.getMessage());
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            for (String element : LOG_PCKG) {
                if (!name.startsWith(element) || name.indexOf("Exception") != -1) continue;
                return this.def(name);
            }
            return super.loadClass(name);
        }
    }
}

