/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.slf4j;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Slf4jLogFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CallerInformationTestCase
extends TestCase {
    private static final String STRING = "String";
    private static final Throwable T = new RuntimeException();
    private static final List<Marker> MARKERS = Collections.singletonList(MarkerFactory.getMarker((String)"COMMONS-LOGGING"));
    private static final Level[] levels = new Level[]{Level.ERROR, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    private LogFactory factory;
    private Log log;
    private ListAppender<ILoggingEvent> appender;

    public void setUp() {
        this.factory = LogFactory.getFactory();
        this.log = this.factory.getInstance(((Object)((Object)this)).getClass());
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("ROOT");
        this.appender = (ListAppender)logger.getAppender("LIST");
        this.appender.clearAllFilters();
        this.appender.addFilter((Filter)new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                event.getCallerData();
                return FilterReply.NEUTRAL;
            }
        });
    }

    public void testFactoryClassName() {
        CallerInformationTestCase.assertEquals(Slf4jLogFactory.class, this.factory.getClass());
    }

    public void testLocationInfo() {
        this.appender.list.clear();
        int currentLineNumber = 78;
        this.log.fatal((Object)STRING);
        this.log.fatal((Object)STRING, T);
        this.log.error((Object)STRING);
        this.log.error((Object)STRING, T);
        this.log.warn((Object)STRING);
        this.log.warn((Object)STRING, T);
        this.log.info((Object)STRING);
        this.log.info((Object)STRING, T);
        this.log.debug((Object)STRING);
        this.log.debug((Object)STRING, T);
        this.log.trace((Object)STRING);
        this.log.trace((Object)STRING, T);
        ArrayList events = new ArrayList(this.appender.list);
        CallerInformationTestCase.assertEquals((String)"All events received.", (int)(levels.length * 2), (int)events.size());
        for (int lev = 0; lev < levels.length; ++lev) {
            for (int hasThrowable = 0; hasThrowable <= 1; ++hasThrowable) {
                ILoggingEvent event = (ILoggingEvent)events.get(2 * lev + hasThrowable);
                CallerInformationTestCase.assertEquals((String)"Correct message.", (String)STRING, (String)event.getMessage());
                CallerInformationTestCase.assertEquals((String)"Correct marker.", MARKERS, (Object)event.getMarkerList());
                CallerInformationTestCase.assertEquals((String)"Level matches.", (Object)levels[lev], (Object)event.getLevel());
                StackTraceElement[] callerData = event.getCallerData();
                CallerInformationTestCase.assertTrue((String)"Has location", (callerData != null && callerData.length > 0 ? 1 : 0) != 0);
                StackTraceElement location = callerData[0];
                CallerInformationTestCase.assertEquals((String)"Correct location class.", (String)((Object)((Object)this)).getClass().getName(), (String)location.getClassName());
                CallerInformationTestCase.assertEquals((String)"Correct location line.", (int)(78 + 2 * lev + hasThrowable + 1), (int)location.getLineNumber());
                ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
                CallerInformationTestCase.assertEquals((String)"Correct exception", (Object)(hasThrowable > 0 ? T : null), (Object)(throwableProxy != null ? throwableProxy.getThrowable() : null));
            }
        }
    }
}

