/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.WeakHashtable;

public class WeakHashtableTestCase
extends TestCase {
    private static final int WAIT_FOR_THREAD_COMPLETION = 5000;
    private static final int RUN_LOOPS = 3000;
    private static final int OUTER_LOOP = 400;
    private static final int THREAD_COUNT = 10;
    private static WeakHashtable hashtable;
    private static final int MAX_GC_ITERATIONS = 50;
    private WeakHashtable weakHashtable;
    private Long keyOne;
    private Long keyTwo;
    private Long keyThree;
    private Long valueOne;
    private Long valueTwo;
    private Long valueThree;

    public WeakHashtableTestCase(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.weakHashtable = new WeakHashtable();
        this.keyOne = 1L;
        this.keyTwo = 2L;
        this.keyThree = 3L;
        this.valueOne = 100L;
        this.valueTwo = 200L;
        this.valueThree = 300L;
        this.weakHashtable.put((Object)this.keyOne, (Object)this.valueOne);
        this.weakHashtable.put((Object)this.keyTwo, (Object)this.valueTwo);
        this.weakHashtable.put((Object)this.keyThree, (Object)this.valueThree);
    }

    public void testContains() throws Exception {
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.contains((Object)1L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.contains((Object)2L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.contains((Object)3L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.contains((Object)100L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.contains((Object)200L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.contains((Object)300L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.contains((Object)400L));
    }

    public void testContainsKey() throws Exception {
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsKey((Object)1L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsKey((Object)2L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsKey((Object)3L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsKey((Object)100L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsKey((Object)200L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsKey((Object)300L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsKey((Object)400L));
    }

    public void testContainsValue() throws Exception {
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsValue((Object)1L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsValue((Object)2L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsValue((Object)3L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsValue((Object)100L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsValue((Object)200L));
        WeakHashtableTestCase.assertTrue((boolean)this.weakHashtable.containsValue((Object)300L));
        WeakHashtableTestCase.assertFalse((boolean)this.weakHashtable.containsValue((Object)400L));
    }

    public void testElements() throws Exception {
        ArrayList elements = new ArrayList();
        Enumeration e = this.weakHashtable.elements();
        while (e.hasMoreElements()) {
            elements.add(e.nextElement());
        }
        WeakHashtableTestCase.assertEquals((int)3, (int)elements.size());
        WeakHashtableTestCase.assertTrue((boolean)elements.contains(this.valueOne));
        WeakHashtableTestCase.assertTrue((boolean)elements.contains(this.valueTwo));
        WeakHashtableTestCase.assertTrue((boolean)elements.contains(this.valueThree));
    }

    public void testEntrySet() throws Exception {
        Set entrySet = this.weakHashtable.entrySet();
        for (Object element : entrySet) {
            Map.Entry entry = (Map.Entry)element;
            Object key = entry.getKey();
            if (this.keyOne.equals(key)) {
                WeakHashtableTestCase.assertEquals((Object)this.valueOne, entry.getValue());
                continue;
            }
            if (this.keyTwo.equals(key)) {
                WeakHashtableTestCase.assertEquals((Object)this.valueTwo, entry.getValue());
                continue;
            }
            if (this.keyThree.equals(key)) {
                WeakHashtableTestCase.assertEquals((Object)this.valueThree, entry.getValue());
                continue;
            }
            WeakHashtableTestCase.fail((String)"Unexpected key");
        }
    }

    public void testGet() throws Exception {
        WeakHashtableTestCase.assertEquals((Object)this.valueOne, (Object)this.weakHashtable.get((Object)this.keyOne));
        WeakHashtableTestCase.assertEquals((Object)this.valueTwo, (Object)this.weakHashtable.get((Object)this.keyTwo));
        WeakHashtableTestCase.assertEquals((Object)this.valueThree, (Object)this.weakHashtable.get((Object)this.keyThree));
        WeakHashtableTestCase.assertNull((Object)this.weakHashtable.get((Object)50L));
    }

    public void testKeys() throws Exception {
        ArrayList keys = new ArrayList();
        Enumeration e = this.weakHashtable.keys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        WeakHashtableTestCase.assertEquals((int)3, (int)keys.size());
        WeakHashtableTestCase.assertTrue((boolean)keys.contains(this.keyOne));
        WeakHashtableTestCase.assertTrue((boolean)keys.contains(this.keyTwo));
        WeakHashtableTestCase.assertTrue((boolean)keys.contains(this.keyThree));
    }

    public void testKeySet() throws Exception {
        Set keySet = this.weakHashtable.keySet();
        WeakHashtableTestCase.assertEquals((int)3, (int)keySet.size());
        WeakHashtableTestCase.assertTrue((boolean)keySet.contains(this.keyOne));
        WeakHashtableTestCase.assertTrue((boolean)keySet.contains(this.keyTwo));
        WeakHashtableTestCase.assertTrue((boolean)keySet.contains(this.keyThree));
    }

    public void testLOGGING_119() throws Exception {
        Thread[] t = new Thread[10];
        for (int j = 1; j <= 400; ++j) {
            hashtable = new WeakHashtable();
            for (int i = 0; i < t.length; ++i) {
                t[i] = new StupidThread("Thread:" + i);
                t[i].setDaemon(true);
                t[i].start();
            }
            for (Thread element : t) {
                element.join(5000L);
                if (element.isAlive()) break;
            }
            int active = 0;
            for (Thread element : t) {
                if (!element.isAlive()) continue;
                ++active;
            }
            if (active <= 0) continue;
            WeakHashtableTestCase.fail((String)("Attempt: " + j + " Stuck threads: " + active));
        }
    }

    public void testPut() throws Exception {
        Long anotherKey = 2004L;
        this.weakHashtable.put((Object)anotherKey, (Object)1066L);
        WeakHashtableTestCase.assertEquals((Object)1066L, (Object)this.weakHashtable.get((Object)anotherKey));
        Exception caught = null;
        try {
            this.weakHashtable.put(null, new Object());
        }
        catch (Exception e) {
            caught = e;
        }
        WeakHashtableTestCase.assertNotNull((String)"did not throw an exception adding a null key", (Object)caught);
        caught = null;
        try {
            this.weakHashtable.put(new Object(), null);
        }
        catch (Exception e) {
            caught = e;
        }
        WeakHashtableTestCase.assertNotNull((String)"did not throw an exception adding a null value", (Object)caught);
    }

    public void testPutAll() throws Exception {
        HashMap<Long, Long> newValues = new HashMap<Long, Long>();
        Long newKey = 1066L;
        Long newValue = 1415L;
        newValues.put(newKey, newValue);
        Long anotherNewKey = 1645L;
        Long anotherNewValue = 1815L;
        newValues.put(anotherNewKey, anotherNewValue);
        this.weakHashtable.putAll(newValues);
        WeakHashtableTestCase.assertEquals((int)5, (int)this.weakHashtable.size());
        WeakHashtableTestCase.assertEquals((Object)newValue, (Object)this.weakHashtable.get((Object)newKey));
        WeakHashtableTestCase.assertEquals((Object)anotherNewValue, (Object)this.weakHashtable.get((Object)anotherNewKey));
    }

    public void testRemove() throws Exception {
        this.weakHashtable.remove((Object)this.keyOne);
        WeakHashtableTestCase.assertEquals((int)2, (int)this.weakHashtable.size());
        WeakHashtableTestCase.assertNull((Object)this.weakHashtable.get((Object)this.keyOne));
    }

    public void testValues() throws Exception {
        Collection values = this.weakHashtable.values();
        WeakHashtableTestCase.assertEquals((int)3, (int)values.size());
        WeakHashtableTestCase.assertTrue((boolean)values.contains(this.valueOne));
        WeakHashtableTestCase.assertTrue((boolean)values.contains(this.valueTwo));
        WeakHashtableTestCase.assertTrue((boolean)values.contains(this.valueThree));
    }

    public void xxxIgnoretestRelease() throws Exception {
        WeakHashtableTestCase.assertNotNull((Object)this.weakHashtable.get((Object)1L));
        ReferenceQueue testQueue = new ReferenceQueue();
        WeakReference<Long> weakKeyOne = new WeakReference<Long>(this.keyOne, testQueue);
        this.keyOne = null;
        this.keyTwo = null;
        this.keyThree = null;
        this.valueOne = null;
        this.valueTwo = null;
        this.valueThree = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                WeakHashtableTestCase.fail((String)"Max iterations reached before resource released.");
            }
            if (this.weakHashtable.get((Object)1L) == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
        while (testQueue.poll() == null) {
        }
        WeakHashtableTestCase.assertEquals((String)"underlying table not emptied", (int)0, (int)this.weakHashtable.size());
    }

    public static class StupidThread
    extends Thread {
        public StupidThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            for (int i = 0; i < 3000; ++i) {
                hashtable.put((Object)("key:" + i % 10), (Object)Boolean.TRUE);
                if (i % 50 != 0) continue;
                StupidThread.yield();
            }
        }
    }
}

