/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;

public class PathableClassLoader
extends URLClassLoader {
    private static final URL[] NO_URLS = new URL[0];
    private HashMap lookasides;
    private boolean parentFirst = true;

    public PathableClassLoader(ClassLoader parent) {
        super(NO_URLS, parent);
    }

    public void addLogicalLib(String logicalLib) {
        String fileName = System.getProperty(logicalLib);
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    Assert.fail((String)("Unable to add logical library " + fileName));
                }
                URL libUrl = file.toURL();
                this.addURL(libUrl);
                return;
            }
            catch (MalformedURLException e) {
                throw new UnknownError("Invalid file [" + fileName + "] for logical lib [" + logicalLib + "]");
            }
        }
        URL libUrl = this.libFromClasspath(logicalLib);
        if (libUrl != null) {
            this.addURL(libUrl);
            return;
        }
        throw new UnknownError("Logical lib [" + logicalLib + "] is not defined as a System property.");
    }

    public void addLogicalLib(String[] logicalLibs) {
        for (String logicalLib : logicalLibs) {
            this.addLogicalLib(logicalLib);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public URL getResource(String name) {
        if (this.parentFirst) {
            return super.getResource(name);
        }
        URL local = super.findResource(name);
        if (local != null) {
            return local;
        }
        return super.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.parentFirst) {
            return super.getResourceAsStream(name);
        }
        URL local = super.findResource(name);
        if (local != null) {
            try {
                return local.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.getResourceAsStream(name);
    }

    public Enumeration getResourcesInOrder(String name) throws IOException {
        if (this.parentFirst) {
            return super.getResources(name);
        }
        Enumeration<URL> localUrls = super.findResources(name);
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return localUrls;
        }
        Enumeration<URL> parentUrls = parent.getResources(name);
        ArrayList localItems = this.toList(localUrls);
        ArrayList parentItems = this.toList(parentUrls);
        localItems.addAll(parentItems);
        return Collections.enumeration(localItems);
    }

    private URL libFromClasspath(String logicalLib) {
        ClassLoader cl = this.getClass().getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader ucl = (URLClassLoader)cl;
        URL[] path = ucl.getURLs();
        URL shortestMatch = null;
        int shortestMatchLen = Integer.MAX_VALUE;
        for (URL u : path) {
            String fileName = u.toString();
            if (!fileName.endsWith(".jar")) continue;
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash >= 0) {
                fileName = fileName.substring(lastSlash + 1);
            }
            if (!fileName.startsWith(logicalLib) || fileName.length() >= shortestMatchLen) continue;
            shortestMatch = u;
            shortestMatchLen = fileName.length();
        }
        return shortestMatch;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return super.loadClass(name, resolve);
        }
        if (this.lookasides != null) {
            for (Map.Entry element : this.lookasides.entrySet()) {
                Map.Entry entry = element;
                String prefix = (String)entry.getKey();
                if (!name.startsWith(prefix)) continue;
                ClassLoader loader = (ClassLoader)entry.getValue();
                Class<?> clazz = Class.forName(name, resolve, loader);
                return clazz;
            }
        }
        if (this.parentFirst) {
            return super.loadClass(name, resolve);
        }
        try {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = super.findClass(name);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    public void setParentFirst(boolean state) {
        this.parentFirst = state;
    }

    private ArrayList toList(Enumeration en) {
        ArrayList results = new ArrayList();
        if (en != null) {
            while (en.hasMoreElements()) {
                Object element = en.nextElement();
                results.add(element);
            }
        }
        return results;
    }

    public void useExplicitLoader(String prefix, ClassLoader loader) {
        if (this.lookasides == null) {
            this.lookasides = new HashMap();
        }
        this.lookasides.put(prefix, loader);
    }

    public void useSystemLoader(String prefix) {
        this.useExplicitLoader(prefix, ClassLoader.getSystemClassLoader());
    }
}

