/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractConcurrentInitializerCloseAndExceptionsTest
extends AbstractConcurrentInitializerTest {
    protected static CloseableObject methodThatThrowsException(ExceptionToThrow input) throws IOException, SQLException, ConcurrentException {
        switch (input.ordinal()) {
            case 0: {
                throw new IOException();
            }
            case 1: {
                throw new SQLException();
            }
            case 2: {
                throw new NullPointerException();
            }
        }
        Assertions.fail();
        return new CloseableObject();
    }

    protected abstract ConcurrentInitializer<CloseableObject> createInitializerThatThrowsException(FailableSupplier<CloseableObject, ? extends Exception> var1, FailableConsumer<CloseableObject, ? extends Exception> var2);

    @Test
    public void testCloserThrowsCheckedException() throws ConcurrentException {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, ? extends Exception>)((FailableConsumer)CloseableObject2 -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.IOException)));
        try {
            initializer.get();
            ((AbstractConcurrentInitializer)initializer).close();
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ConcurrentException.class));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testCloserThrowsRuntimeException() throws ConcurrentException {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, ? extends Exception>)((FailableConsumer)CloseableObject2 -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.NullPointerException)));
        initializer.get();
        Assertions.assertThrows(NullPointerException.class, () -> ((AbstractConcurrentInitializer)initializer).close());
    }

    @Test
    public void testSupplierThrowsCheckedException() {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)() -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.IOException)), (FailableConsumer<CloseableObject, ? extends Exception>)FailableConsumer.NOP);
        Assertions.assertThrows(ConcurrentException.class, () -> initializer.get());
    }

    @Test
    public void testSupplierThrowsConcurrentException() {
        ConcurrentException concurrentException = new ConcurrentException();
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)() -> {
            if ("test".equals("test")) {
                throw concurrentException;
            }
            return new CloseableObject();
        }), (FailableConsumer<CloseableObject, ? extends Exception>)FailableConsumer.NOP);
        try {
            initializer.get();
            Assertions.fail();
        }
        catch (ConcurrentException e) {
            Assertions.assertEquals((Object)((Object)concurrentException), (Object)((Object)e));
        }
    }

    @Test
    public void testSupplierThrowsRuntimeException() {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)() -> AbstractConcurrentInitializerCloseAndExceptionsTest.methodThatThrowsException(ExceptionToThrow.NullPointerException)), (FailableConsumer<CloseableObject, ? extends Exception>)FailableConsumer.NOP);
        Assertions.assertThrows(NullPointerException.class, () -> initializer.get());
    }

    @Test
    public void testWorkingCloser() throws Exception {
        ConcurrentInitializer<CloseableObject> initializer = this.createInitializerThatThrowsException((FailableSupplier<CloseableObject, ? extends Exception>)((FailableSupplier)CloseableObject::new), (FailableConsumer<CloseableObject, ? extends Exception>)((FailableConsumer)CloseableObject::close));
        CloseableObject closeableObject = (CloseableObject)initializer.get();
        Assertions.assertFalse((boolean)closeableObject.isClosed());
        ((AbstractConcurrentInitializer)initializer).close();
        Assertions.assertTrue((boolean)closeableObject.isClosed());
    }

    protected static enum ExceptionToThrow {
        IOException,
        SQLException,
        NullPointerException;

    }

    protected static final class CloseableObject {
        boolean closed;

        protected CloseableObject() {
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

