/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class RandomStringUtilsTest
extends AbstractLangTest {
    private static final int LOOP_COUNT = 1000;

    static Stream<RandomStringUtils> randomProvider() {
        return Stream.of(RandomStringUtils.secure(), RandomStringUtils.insecure());
    }

    private double chiSquare(int[] expected, int[] observed) {
        double sumSq = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            double dev = observed[i] - expected[i];
            sumSq += dev * dev / (double)expected[i];
        }
        return sumSq;
    }

    @Test
    public void testCharOverflow() {
        int start = 65535;
        int end = Integer.MAX_VALUE;
        Random fixedRandom = new Random(){

            @Override
            public int nextInt(int n) {
                return super.nextInt(n - 1) + 1;
            }
        };
        String result = RandomStringUtils.random((int)2, (int)65535, (int)Integer.MAX_VALUE, (boolean)false, (boolean)false, null, (Random)fixedRandom);
        int c = result.codePointAt(0);
        Assertions.assertTrue((c >= 65535 && c < Integer.MAX_VALUE ? 1 : 0) != 0, (String)String.format("Character '%d' not in range [%d,%d).", c, 65535, Integer.MAX_VALUE));
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new RandomStringUtils());
    }

    @Test
    public void testExceptionsRandom() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (boolean)true, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (char[])new char[]{'a'}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)1, (char[])new char[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])new char[]{'a'}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])new char[]{'a'}, (Random)new Random()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)8, (int)32, (int)48, (boolean)false, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)8, (int)32, (int)65, (boolean)true, (boolean)false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)1, (int)Integer.MIN_VALUE, (int)-10, (boolean)false, (boolean)false, null));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandom(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, true, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, new char[]{'a'}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(1, new char[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, 97, 122, false, false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(-1, 97, 122, false, false, new char[]{'a'}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(8, 32, 48, false, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(8, 32, 65, true, false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(1, Integer.MIN_VALUE, -10, false, false, null));
    }

    @Test
    public void testExceptionsRandomAlphabetic() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.randomAlphabetic((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandomAlphabetic(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.nextAlphabetic(-1));
    }

    @Test
    public void testExceptionsRandomAscii() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.randomAscii((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandomAscii(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.nextAscii(-1));
    }

    @Test
    public void testExceptionsRandomGraph() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.randomGraph((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandomGraph(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.nextGraph(-1));
    }

    @Test
    public void testExceptionsRandomNumeric() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.randomNumeric((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandomNumeric(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.nextNumeric(-1));
    }

    @Test
    public void testExceptionsRandomPrint() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.randomPrint((int)-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testExceptionsRandomPrint(RandomStringUtils rsu) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.nextPrint(-1));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testHomogeneity(RandomStringUtils rsu) {
        String set = "abc";
        char[] chars = "abc".toCharArray();
        int[] counts = new int[]{0, 0, 0};
        int[] expected = new int[]{200, 200, 200};
        for (int i = 0; i < 100; ++i) {
            String gen = rsu.next(6, chars);
            block6: for (int j = 0; j < 6; ++j) {
                switch (gen.charAt(j)) {
                    case 'a': {
                        counts[0] = counts[0] + 1;
                        continue block6;
                    }
                    case 'b': {
                        counts[1] = counts[1] + 1;
                        continue block6;
                    }
                    case 'c': {
                        counts[2] = counts[2] + 1;
                        continue block6;
                    }
                    default: {
                        Assertions.fail((String)"generated character not in set");
                    }
                }
            }
        }
        MatcherAssert.assertThat((String)"test homogeneity -- will fail about 1 in 100,000 times", (Object)this.chiSquare(expected, counts), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(23.025850929940457)));
    }

    @Test
    public void testLang100() {
        int size = 5000;
        Charset charset = StandardCharsets.UTF_8;
        String orig = RandomStringUtils.random((int)5000);
        byte[] bytes = orig.getBytes(charset);
        String copy = new String(bytes, charset);
        for (int i = 0; i < orig.length() && i < copy.length(); ++i) {
            char o = orig.charAt(i);
            char c = copy.charAt(i);
            Assertions.assertEquals((char)o, (char)c, (String)("differs at " + i + "(" + Integer.toHexString(Character.valueOf(o).hashCode()) + "," + Integer.toHexString(Character.valueOf(c).hashCode()) + ")"));
        }
        Assertions.assertEquals((int)orig.length(), (int)copy.length());
        Assertions.assertEquals((Object)orig, (Object)copy);
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testLang100(RandomStringUtils rsu) {
        int size = 5000;
        Charset charset = StandardCharsets.UTF_8;
        String orig = rsu.next(5000);
        byte[] bytes = orig.getBytes(charset);
        String copy = new String(bytes, charset);
        for (int i = 0; i < orig.length() && i < copy.length(); ++i) {
            char o = orig.charAt(i);
            char c = copy.charAt(i);
            Assertions.assertEquals((char)o, (char)c, (String)("differs at " + i + "(" + Integer.toHexString(Character.valueOf(o).hashCode()) + "," + Integer.toHexString(Character.valueOf(c).hashCode()) + ")"));
        }
        Assertions.assertEquals((int)orig.length(), (int)copy.length());
        Assertions.assertEquals((Object)orig, (Object)copy);
    }

    @Test
    public void testLANG805() {
        long seedMillis = System.currentTimeMillis();
        Assertions.assertEquals((Object)"aaa", (Object)RandomStringUtils.random((int)3, (int)0, (int)0, (boolean)false, (boolean)false, (char[])new char[]{'a'}, (Random)new Random(seedMillis)));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testLANG807(RandomStringUtils rsu) {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> rsu.next(3, 5, 5, false, false));
        String msg = ex.getMessage();
        Assertions.assertTrue((boolean)msg.contains("start"), (String)("Message (" + msg + ") must contain 'start'"));
        Assertions.assertTrue((boolean)msg.contains("end"), (String)("Message (" + msg + ") must contain 'end'"));
    }

    @Test
    public void testRandomAlphabetic() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z'};
        boolean[] found = new boolean[]{false, false, false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = RandomStringUtils.randomAlphabetic((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomAlphabetic(RandomStringUtils rsu) {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z'};
        boolean[] found = new boolean[]{false, false, false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = rsu.nextAlphabetic(10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAlphabeticRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Alpha}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomAlphabetic((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Alpha}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomAlphabeticRange(RandomStringUtils rsu) {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Alpha}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = rsu.nextAlphabetic(1, 11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Alpha}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomAlphaNumeric() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z', '0', '9'};
        boolean[] found = new boolean[]{false, false, false, false, false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = RandomStringUtils.randomAlphanumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomAlphaNumeric(RandomStringUtils rsu) {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z', '0', '9'};
        boolean[] found = new boolean[]{false, false, false, false, false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = rsu.nextAlphanumeric(10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAlphanumericRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Alnum}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomAlphanumeric((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Alnum}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomApis(RandomStringUtils rsu) {
        int i;
        int i2;
        String r1 = rsu.next(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        String r2 = rsu.next(50);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextAscii(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAscii(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            MatcherAssert.assertThat((String)"char >= 32 && <= 127", (Object)r1.charAt(i2), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(32)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(127))));
        }
        r2 = rsu.nextAscii(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextAlphabetic(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAlphabetic(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((Character.isLetter(r1.charAt(i2)) && !Character.isDigit(r1.charAt(i2)) ? 1 : 0) != 0, (String)"r1 contains alphabetic");
        }
        r2 = rsu.nextAlphabetic(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextAlphanumeric(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAlphanumeric(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((boolean)Character.isLetterOrDigit(r1.charAt(i2)), (String)"r1 contains alphanumeric");
        }
        r2 = rsu.nextAlphabetic(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextGraph(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomGraph(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((r1.charAt(i2) >= '!' && r1.charAt(i2) <= '~' ? 1 : 0) != 0, (String)"char between 33 and 126");
        }
        r2 = rsu.nextGraph(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextNumeric(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomNumeric(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((Character.isDigit(r1.charAt(i2)) && !Character.isLetter(r1.charAt(i2)) ? 1 : 0) != 0, (String)"r1 contains numeric");
        }
        r2 = rsu.nextNumeric(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.nextPrint(50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomPrint(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((r1.charAt(i2) >= ' ' && r1.charAt(i2) <= '~' ? 1 : 0) != 0, (String)"char between 32 and 126");
        }
        r2 = rsu.nextPrint(50);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        String set = "abcdefg";
        r1 = rsu.next(50, set);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50, \"abcdefg\")");
        for (i = 0; i < r1.length(); ++i) {
            Assertions.assertTrue((set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0, (String)"random char in set");
        }
        r2 = rsu.next(50, set);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.next(50, (String)null);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        r2 = rsu.next(50, (String)null);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        set = "stuvwxyz";
        r1 = rsu.next(50, set.toCharArray());
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50, \"stuvwxyz\")");
        for (i = 0; i < r1.length(); ++i) {
            Assertions.assertTrue((set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0, (String)"random char in set");
        }
        r2 = rsu.next(50, set);
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.next(50, (char[])null);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        r2 = rsu.next(50, (char[])null);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertFalse((boolean)r1.equals(r2), (String)"!r1.equals(r2)");
        r1 = rsu.next(0);
        Assertions.assertEquals((Object)"", (Object)r1, (String)"random(0).equals(\"\")");
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomAscii(RandomStringUtils rsu) {
        int i;
        char[] testChars = new char[]{' ', '~'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = rsu.nextAscii(10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("ascii character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomAsciiRange(RandomStringUtils rsu) {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{ASCII}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = rsu.nextAscii(1, 11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{ASCII}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomGraphRange(RandomStringUtils rsu) {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Graph}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = rsu.nextGraph(1, 11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Graph}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomNumeric(RandomStringUtils rsu) {
        int i;
        char[] testChars = new char[]{'0', '9'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 1000; ++i) {
            String randString = rsu.nextNumeric(10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("digit not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomNumericRange(RandomStringUtils rsu) {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Digit}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = rsu.nextNumeric(1, 11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Digit}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomParameter() {
        long seedMillis = System.currentTimeMillis();
        String r1 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seedMillis));
        String r2 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seedMillis));
        Assertions.assertEquals((Object)r1, (Object)r2, (String)"r1.equals(r2)");
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomPrintRange(RandomStringUtils rsu) {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Print}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = rsu.nextPrint(1, 11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Print}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @ParameterizedTest
    @MethodSource(value={"randomProvider"})
    public void testRandomWithChars(RandomStringUtils rsu) {
        char[] digitChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        String r1 = rsu.next(50, 0, 0, true, true, digitChars);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomNumeric(50)");
        for (int i = 0; i < r1.length(); ++i) {
            Assertions.assertTrue((Character.isDigit(r1.charAt(i)) && !Character.isLetter(r1.charAt(i)) ? 1 : 0) != 0, (String)"r1 contains numeric");
        }
        String r2 = rsu.nextNumeric(50);
        Assertions.assertNotEquals((Object)r1, (Object)r2);
        String r3 = rsu.next(50, 0, 0, true, true, digitChars);
        Assertions.assertNotEquals((Object)r1, (Object)r3);
        Assertions.assertNotEquals((Object)r2, (Object)r3);
    }
}

