/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImmutableTripleTest
extends AbstractLangTest {
    @Test
    public void testBasic() {
        ImmutableTriple triple = new ImmutableTriple((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assertions.assertEquals((int)0, (int)((Integer)triple.left));
        Assertions.assertEquals((int)0, (int)((Integer)triple.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)triple.middle);
        Assertions.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)triple.right);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)triple.getRight());
        ImmutableTriple triple2 = new ImmutableTriple(null, (Object)"bar", (Object)42);
        Assertions.assertNull((Object)triple2.left);
        Assertions.assertNull((Object)triple2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)triple2.middle);
        Assertions.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assertions.assertEquals((Integer)42, (Integer)((Integer)triple2.right));
        Assertions.assertEquals((Integer)42, (Integer)((Integer)triple2.getRight()));
    }

    @Test
    public void testEmptyArrayGenerics() {
        ImmutableTriple[] empty = ImmutableTriple.emptyArray();
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testEmptyArrayLength() {
        ImmutableTriple[] empty = ImmutableTriple.EMPTY_ARRAY;
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)ImmutableTriple.of(null, (Object)"foo", (Object)42), (Object)ImmutableTriple.of(null, (Object)"foo", (Object)42));
        Assertions.assertNotEquals((Object)ImmutableTriple.of((Object)"foo", (Object)0, (Object)Boolean.TRUE), (Object)ImmutableTriple.of((Object)"foo", null, null));
        Assertions.assertNotEquals((Object)ImmutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz"), (Object)ImmutableTriple.of((Object)"xyz", (Object)"bar", (Object)"blo"));
        ImmutableTriple p = ImmutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)ImmutableTriple.of(null, (Object)"foo", (Object)Boolean.TRUE).hashCode(), (int)ImmutableTriple.of(null, (Object)"foo", (Object)Boolean.TRUE).hashCode());
    }

    @Test
    public void testNullTripleEquals() {
        Assertions.assertEquals((Object)ImmutableTriple.nullTriple(), (Object)ImmutableTriple.nullTriple());
    }

    @Test
    public void testNullTripleLeft() {
        Assertions.assertNull((Object)ImmutableTriple.nullTriple().getLeft());
    }

    @Test
    public void testNullTripleMiddle() {
        Assertions.assertNull((Object)ImmutableTriple.nullTriple().getMiddle());
    }

    @Test
    public void testNullTripleRight() {
        Assertions.assertNull((Object)ImmutableTriple.nullTriple().getRight());
    }

    @Test
    public void testNullTripleSame() {
        Assertions.assertSame((Object)ImmutableTriple.nullTriple(), (Object)ImmutableTriple.nullTriple());
    }

    @Test
    public void testNullTripleTyped() {
        ImmutableTriple triple = ImmutableTriple.nullTriple();
        Assertions.assertNotNull((Object)triple);
    }

    @Test
    public void testOfNonNull() {
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableTriple.ofNonNull(null, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableTriple.ofNonNull(null, null, (Object)"z"));
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableTriple.ofNonNull(null, (Object)"y", (Object)"z"));
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableTriple.ofNonNull((Object)"x", null, null));
        Assertions.assertThrows(NullPointerException.class, () -> ImmutableTriple.ofNonNull((Object)"x", (Object)"y", null));
        ImmutableTriple pair = ImmutableTriple.ofNonNull((Object)"x", (Object)"y", (Object)"z");
        Assertions.assertEquals((Object)"x", (Object)pair.left);
        Assertions.assertEquals((Object)"y", (Object)pair.middle);
        Assertions.assertEquals((Object)"z", (Object)pair.right);
    }

    @Test
    public void testSerialization() throws Exception {
        ImmutableTriple origTriple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        ImmutableTriple deserializedTriple = (ImmutableTriple)SerializationUtils.roundtrip((Serializable)origTriple);
        Assertions.assertEquals((Object)origTriple, (Object)deserializedTriple);
        Assertions.assertEquals((int)origTriple.hashCode(), (int)deserializedTriple.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null,null)", (Object)ImmutableTriple.of(null, null, null).toString());
        Assertions.assertEquals((Object)"(null,two,null)", (Object)ImmutableTriple.of(null, (Object)"two", null).toString());
        Assertions.assertEquals((Object)"(one,null,null)", (Object)ImmutableTriple.of((Object)"one", null, null).toString());
        Assertions.assertEquals((Object)"(one,two,null)", (Object)ImmutableTriple.of((Object)"one", (Object)"two", null).toString());
        Assertions.assertEquals((Object)"(null,two,three)", (Object)ImmutableTriple.of(null, (Object)"two", (Object)"three").toString());
        Assertions.assertEquals((Object)"(one,null,three)", (Object)ImmutableTriple.of((Object)"one", null, (Object)"three").toString());
        Assertions.assertEquals((Object)"(one,two,three)", (Object)MutableTriple.of((Object)"one", (Object)"two", (Object)"three").toString());
    }

    @Test
    public void testTripleOf() {
        ImmutableTriple triple = ImmutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.FALSE);
        Assertions.assertEquals((int)0, (int)((Integer)triple.left));
        Assertions.assertEquals((int)0, (int)((Integer)triple.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)triple.middle);
        Assertions.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)triple.right);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
        ImmutableTriple triple2 = ImmutableTriple.of(null, (Object)"bar", (Object)Boolean.TRUE);
        Assertions.assertNull((Object)triple2.left);
        Assertions.assertNull((Object)triple2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)triple2.middle);
        Assertions.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)triple2.right);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)triple2.getRight());
    }

    @Test
    public void testUseAsKeyOfHashMap() {
        HashMap<ImmutableTriple, String> map = new HashMap<ImmutableTriple, String>();
        Object o1 = new Object();
        Object o2 = new Object();
        Object o3 = new Object();
        ImmutableTriple key1 = ImmutableTriple.of((Object)o1, (Object)o2, (Object)o3);
        String value1 = "a1";
        map.put(key1, "a1");
        Assertions.assertEquals((Object)"a1", map.get(key1));
        Assertions.assertEquals((Object)"a1", map.get(ImmutableTriple.of((Object)o1, (Object)o2, (Object)o3)));
    }

    @Test
    public void testUseAsKeyOfTreeMap() {
        TreeMap<ImmutableTriple, String> map = new TreeMap<ImmutableTriple, String>();
        map.put(ImmutableTriple.of((Object)0, (Object)1, (Object)2), "012");
        map.put(ImmutableTriple.of((Object)0, (Object)1, (Object)1), "011");
        map.put(ImmutableTriple.of((Object)0, (Object)0, (Object)1), "001");
        ArrayList<ImmutableTriple> expected = new ArrayList<ImmutableTriple>();
        expected.add(ImmutableTriple.of((Object)0, (Object)0, (Object)1));
        expected.add(ImmutableTriple.of((Object)0, (Object)1, (Object)1));
        expected.add(ImmutableTriple.of((Object)0, (Object)1, (Object)2));
        Iterator it = map.entrySet().iterator();
        for (ImmutableTriple item : expected) {
            Map.Entry entry = it.next();
            Assertions.assertEquals((Object)item, entry.getKey());
            Assertions.assertEquals((Object)(item.getLeft() + "" + item.getMiddle() + "" + item.getRight()), entry.getValue());
        }
    }
}

