/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.mutable.MutableByte;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableByteTest
extends AbstractLangTest {
    @Test
    public void testAddAndGetValueObject() {
        MutableByte mutableByte = new MutableByte(0);
        byte result = mutableByte.addAndGet((Number)1);
        Assertions.assertEquals((byte)1, (byte)result);
        Assertions.assertEquals((byte)1, (byte)mutableByte.byteValue());
    }

    @Test
    public void testAddAndGetValuePrimitive() {
        MutableByte mutableByte = new MutableByte(0);
        byte result = mutableByte.addAndGet((byte)1);
        Assertions.assertEquals((byte)1, (byte)result);
        Assertions.assertEquals((byte)1, (byte)mutableByte.byteValue());
    }

    @Test
    public void testAddValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((Number)1);
        Assertions.assertEquals((byte)2, (byte)mutNum.byteValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.add((byte)1);
        Assertions.assertEquals((byte)2, (byte)mutNum.byteValue());
    }

    @Test
    public void testCompareTo() {
        MutableByte mutNum = new MutableByte(0);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableByte(0)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableByte(-1)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableByte(1)));
    }

    @Test
    public void testCompareToNull() {
        MutableByte mutNum = new MutableByte(0);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.compareTo(null));
    }

    @Test
    public void testConstructorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MutableByte((Number)null));
    }

    @Test
    public void testConstructors() {
        Assertions.assertEquals((byte)0, (byte)new MutableByte().byteValue());
        Assertions.assertEquals((byte)1, (byte)new MutableByte(1).byteValue());
        Assertions.assertEquals((byte)2, (byte)new MutableByte((Number)2).byteValue());
        Assertions.assertEquals((byte)3, (byte)new MutableByte((Number)new MutableByte(3)).byteValue());
        Assertions.assertEquals((byte)2, (byte)new MutableByte("2").byteValue());
    }

    @Test
    public void testDecrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrementAndGet() {
        MutableByte mutNum = new MutableByte(1);
        byte result = mutNum.decrementAndGet();
        Assertions.assertEquals((int)0, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testEquals() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)0);
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    public void testGetAndAddValueObject() {
        MutableByte mutableByte = new MutableByte(0);
        byte result = mutableByte.getAndAdd((Number)1);
        Assertions.assertEquals((byte)0, (byte)result);
        Assertions.assertEquals((byte)1, (byte)mutableByte.byteValue());
    }

    @Test
    public void testGetAndAddValuePrimitive() {
        MutableByte mutableByte = new MutableByte(0);
        byte result = mutableByte.getAndAdd((byte)1);
        Assertions.assertEquals((byte)0, (byte)result);
        Assertions.assertEquals((byte)1, (byte)mutableByte.byteValue());
    }

    @Test
    public void testGetAndDecrement() {
        MutableByte mutNum = new MutableByte(1);
        byte result = mutNum.getAndDecrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndIncrement() {
        MutableByte mutNum = new MutableByte(1);
        byte result = mutNum.getAndIncrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testGetSet() {
        MutableByte mutNum = new MutableByte(0);
        Assertions.assertEquals((byte)0, (byte)new MutableByte().byteValue());
        Assertions.assertEquals((Byte)0, (Byte)new MutableByte().getValue());
        mutNum.setValue((byte)1);
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((Byte)1, (Byte)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assertions.assertEquals((byte)2, (byte)mutNum.byteValue());
        Assertions.assertEquals((Byte)2, (Byte)mutNum.getValue());
        mutNum.setValue((Number)new MutableByte(3));
        Assertions.assertEquals((byte)3, (byte)mutNum.byteValue());
        Assertions.assertEquals((Byte)3, (Byte)mutNum.getValue());
    }

    @Test
    public void testHashCode() {
        MutableByte mutNumA = new MutableByte(0);
        MutableByte mutNumB = new MutableByte(0);
        MutableByte mutNumC = new MutableByte(1);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Byte.valueOf((byte)0).hashCode());
    }

    @Test
    public void testIncrement() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testIncrementAndGet() {
        MutableByte mutNum = new MutableByte(1);
        byte result = mutNum.incrementAndGet();
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testPrimitiveValues() {
        MutableByte mutNum = new MutableByte(1);
        Assertions.assertEquals((float)1.0f, (float)mutNum.floatValue());
        Assertions.assertEquals((double)1.0, (double)mutNum.doubleValue());
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testSetNull() {
        MutableByte mutNum = new MutableByte(0);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.setValue(null));
    }

    @Test
    public void testSubtractValueObject() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((Number)1);
        Assertions.assertEquals((byte)0, (byte)mutNum.byteValue());
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableByte mutNum = new MutableByte(1);
        mutNum.subtract((byte)1);
        Assertions.assertEquals((byte)0, (byte)mutNum.byteValue());
    }

    @Test
    public void testToByte() {
        Assertions.assertEquals((Byte)0, (Byte)new MutableByte(0).toByte());
        Assertions.assertEquals((Byte)123, (Byte)new MutableByte(123).toByte());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"0", (Object)new MutableByte(0).toString());
        Assertions.assertEquals((Object)"10", (Object)new MutableByte(10).toString());
        Assertions.assertEquals((Object)"-123", (Object)new MutableByte(-123).toString());
    }
}

