/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DiffBuilderTest
extends AbstractLangTest {
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;

    @Test
    public void testBoolean() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.booleanField = false;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals(Boolean.class, (Object)diff.getType(), () -> diff.getType().getClass().toString());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)diff.getLeft());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)diff.getRight());
    }

    @Test
    public void testBooleanArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$402(class2, new boolean[]{false, false});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((boolean[])class1.booleanArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((boolean[])class2.booleanArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testByte() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.byteField = (byte)1;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals(Byte.class, (Object)diff.getType(), () -> diff.getType().getClass().toString());
        Assertions.assertEquals((Object)class1.byteField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.byteField, (Object)diff.getRight());
    }

    @Test
    public void testByteArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$602(class2, new byte[]{1, 2});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((byte[])class1.byteArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((byte[])class2.byteArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testByteArrayEqualAsObject1() {
        DiffResult list = DiffBuilder.builder().setLeft((Object)"String1").setRight((Object)"String2").setStyle(SHORT_STYLE).build().append("foo", new boolean[]{false}, new boolean[]{false}).append("foo", new byte[]{1}, new byte[]{1}).append("foo", new char[]{'a'}, new char[]{'a'}).append("foo", new double[]{1.0}, new double[]{1.0}).append("foo", new float[]{1.0f}, new float[]{1.0f}).append("foo", new int[]{1}, new int[]{1}).append("foo", new long[]{1L}, new long[]{1L}).append("foo", new short[]{1}, new short[]{1}).append("foo", new Object[]{1, "two"}, new Object[]{1, "two"}).build();
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testByteArrayEqualAsObjectDeprecated() {
        DiffResult list = new DiffBuilder((Object)"String1", (Object)"String2", SHORT_STYLE).append("foo", new boolean[]{false}, new boolean[]{false}).append("foo", new byte[]{1}, new byte[]{1}).append("foo", new char[]{'a'}, new char[]{'a'}).append("foo", new double[]{1.0}, new double[]{1.0}).append("foo", new float[]{1.0f}, new float[]{1.0f}).append("foo", new int[]{1}, new int[]{1}).append("foo", new long[]{1L}, new long[]{1L}).append("foo", new short[]{1}, new short[]{1}).append("foo", new Object[]{1, "two"}, new Object[]{1, "two"}).build();
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testChar() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.charField = 'z';
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)Character.valueOf(class1.charField), (Object)diff.getLeft());
        Assertions.assertEquals((Object)Character.valueOf(class2.charField), (Object)diff.getRight());
    }

    @Test
    public void testCharArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$802(class2, new char[]{'f', 'o', 'o'});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((char[])class1.charArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((char[])class2.charArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testDiffResult() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.intField = 2;
        DiffResult list = new DiffBuilder((Object)class1, (Object)class2, SHORT_STYLE).append("prop1", class1.diff(class2)).build();
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Assertions.assertEquals((Object)"prop1.int", (Object)((Diff)list.getDiffs().get(0)).getFieldName());
    }

    @Test
    public void testDiffResultEquals() {
        TypeTestClass class1 = new TypeTestClass();
        class1.intField = 2;
        DiffResult list = new DiffBuilder((Object)class1, (Object)class1, SHORT_STYLE).append("prop1", class1.diff(class1)).build();
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
        Assertions.assertTrue((boolean)list.getDiffs().isEmpty());
    }

    @Test
    public void testDouble() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.doubleField = 99.99;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)class1.doubleField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.doubleField, (Object)diff.getRight());
    }

    @Test
    public void testDoubleArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1102(class2, new double[]{3.0, 2.9, 2.8});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((double[])class1.doubleArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((double[])class2.doubleArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testFloat() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.floatField = 99.99f;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)Float.valueOf(class1.floatField), (Object)diff.getLeft());
        Assertions.assertEquals((Object)Float.valueOf(class2.floatField), (Object)diff.getRight());
    }

    @Test
    public void testFloatArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1302(class2, new float[]{3.0f, 2.9f, 2.8f});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((float[])class1.floatArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((float[])class2.floatArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testInt() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.intField = 42;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)class1.intField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.intField, (Object)diff.getRight());
    }

    @Test
    public void testIntArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1402(class2, new int[]{3, 2, 1});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((int[])class1.intArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((int[])class2.intArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testLong() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.longField = 42L;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)class1.longField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.longField, (Object)diff.getRight());
    }

    @Test
    public void testLongArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$1602(class2, new long[]{3L, 2L, 1L});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((long[])class1.longArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((long[])class2.longArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testNestedDiffableNo() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
        List diff = list.getDiffs();
        Assertions.assertTrue((boolean)diff.isEmpty());
    }

    @Test
    public void testNestedDiffableYesNestedOnly() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.nestedDiffableField.booleanField = false;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals(Object.class, (Object)diff.getType());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)diff.getLeft());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)diff.getRight());
    }

    @Test
    public void testNestedDiffableYesNestedNot() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.intField = 9;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals(Integer.class, (Object)diff.getType());
        Assertions.assertEquals((Object)1, (Object)diff.getLeft());
        Assertions.assertEquals((Object)9, (Object)diff.getRight());
    }

    @Test
    public void testNestedDiffableYesNestedYes() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.intField = 9;
        class2.nestedDiffableField.booleanField = false;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)2, (int)list.getNumberOfDiffs());
        Diff diff0 = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals(Integer.class, (Object)diff0.getType());
        Assertions.assertEquals((Object)1, (Object)diff0.getLeft());
        Assertions.assertEquals((Object)9, (Object)diff0.getRight());
        Diff diff1 = (Diff)list.getDiffs().get(1);
        Assertions.assertEquals(Object.class, (Object)diff1.getType());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)diff1.getLeft());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)diff1.getRight());
    }

    @Test
    public void testNullLhs() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffBuilder(null, (Object)this, ToStringStyle.DEFAULT_STYLE));
    }

    @Test
    public void testNullLhs_4args() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffBuilder(null, (Object)this, ToStringStyle.DEFAULT_STYLE, true));
    }

    @Test
    public void testNullRhs() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffBuilder((Object)this, null, ToStringStyle.DEFAULT_STYLE));
    }

    @Test
    public void testNullRhs_4args() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffBuilder((Object)this, null, ToStringStyle.DEFAULT_STYLE, true));
    }

    @Test
    public void testObject() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.objectField = "Some string";
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)class1.objectField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.objectField, (Object)diff.getRight());
    }

    @Test
    public void testObjectArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$2002(class2, new Object[]{"string", 1, 2});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])class1.objectArrayField, (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])class2.objectArrayField, (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testObjectArrayEqual() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$2002(class1, new Object[]{"string", 1, 2});
        TypeTestClass.access$2002(class2, new Object[]{"string", 1, 2});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectsNotSameButEqual() {
        TypeTestClass left = new TypeTestClass();
        left.objectField = 1000;
        TypeTestClass right = new TypeTestClass();
        right.objectField = 1000;
        Assertions.assertNotSame((Object)left.objectField, (Object)right.objectField);
        Assertions.assertEquals((Object)left.objectField, (Object)right.objectField);
        DiffResult<TypeTestClass> list = left.diff(right);
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectsNotSameNorEqual() {
        TypeTestClass left = new TypeTestClass();
        left.objectField = 4;
        TypeTestClass right = new TypeTestClass();
        right.objectField = 100;
        Assertions.assertNotSame((Object)left.objectField, (Object)right.objectField);
        Assertions.assertNotEquals((Object)left.objectField, (Object)right.objectField);
        DiffResult<TypeTestClass> list = left.diff(right);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testObjectsSameAndEqual() {
        Integer sameObject = 1;
        TypeTestClass left = new TypeTestClass();
        left.objectField = sameObject;
        TypeTestClass right = new TypeTestClass();
        right.objectField = sameObject;
        Assertions.assertSame((Object)left.objectField, (Object)right.objectField);
        Assertions.assertEquals((Object)left.objectField, (Object)right.objectField);
        DiffResult<TypeTestClass> list = left.diff(right);
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testSameObjectIgnoresAppends() {
        TypeTestClass testClass = new TypeTestClass();
        DiffResult list = new DiffBuilder((Object)testClass, (Object)testClass, SHORT_STYLE).append("ignored", false, true).build();
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testShort() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        class2.shortField = (short)42;
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertEquals((Object)class1.shortField, (Object)diff.getLeft());
        Assertions.assertEquals((Object)class2.shortField, (Object)diff.getRight());
    }

    @Test
    public void testShortArray() {
        TypeTestClass class1 = new TypeTestClass();
        TypeTestClass class2 = new TypeTestClass();
        TypeTestClass.access$2202(class2, new short[]{3, 2, 1});
        DiffResult<TypeTestClass> list = class1.diff(class2);
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Diff diff = (Diff)list.getDiffs().get(0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((short[])class1.shortArrayField), (Object[])((Object[])diff.getLeft()));
        Assertions.assertArrayEquals((Object[])ArrayUtils.toObject((short[])class2.shortArrayField), (Object[])((Object[])diff.getRight()));
    }

    @Test
    public void testSimilarObjectIgnoresAppends() {
        TypeTestClass testClass1 = new TypeTestClass();
        TypeTestClass testClass2 = new TypeTestClass();
        DiffResult list = new DiffBuilder((Object)testClass1, (Object)testClass2, SHORT_STYLE).append("ignored", false, true).build();
        Assertions.assertEquals((int)0, (int)list.getNumberOfDiffs());
    }

    @Test
    public void testStylePassedToDiffResult() {
        TypeTestClass class1 = new TypeTestClass();
        DiffResult<TypeTestClass> list = class1.diff(class1);
        Assertions.assertEquals((Object)SHORT_STYLE, (Object)list.getToStringStyle());
        class1.style = ToStringStyle.MULTI_LINE_STYLE;
        list = class1.diff(class1);
        Assertions.assertEquals((Object)ToStringStyle.MULTI_LINE_STYLE, (Object)list.getToStringStyle());
    }

    @Test
    public void testTriviallyEqualTestDisabled() {
        Matcher equalToOne = IsEqual.equalTo((Object)1);
        DiffBuilder explicitTestAndNotEqual1 = new DiffBuilder((Object)1, (Object)2, null, false);
        explicitTestAndNotEqual1.append("letter", (Object)"X", (Object)"Y");
        MatcherAssert.assertThat((Object)explicitTestAndNotEqual1.build().getNumberOfDiffs(), (Matcher)equalToOne);
        DiffBuilder explicitTestAndNotEqual2 = new DiffBuilder((Object)1, (Object)1, null, false);
        explicitTestAndNotEqual2.append("letter", (Object)"X", (Object)"Y");
        MatcherAssert.assertThat((Object)explicitTestAndNotEqual2.build().getNumberOfDiffs(), (Matcher)equalToOne);
    }

    @Test
    public void testTriviallyEqualTestEnabled() {
        Matcher equalToZero = IsEqual.equalTo((Object)0);
        Matcher equalToOne = IsEqual.equalTo((Object)1);
        DiffBuilder implicitTestAndEqual = new DiffBuilder((Object)1, (Object)1, null);
        implicitTestAndEqual.append("letter", (Object)"X", (Object)"Y");
        MatcherAssert.assertThat((Object)implicitTestAndEqual.build().getNumberOfDiffs(), (Matcher)equalToZero);
        DiffBuilder implicitTestAndNotEqual = new DiffBuilder((Object)1, (Object)2, null);
        implicitTestAndNotEqual.append("letter", (Object)"X", (Object)"Y");
        MatcherAssert.assertThat((Object)implicitTestAndNotEqual.build().getNumberOfDiffs(), (Matcher)equalToOne);
        DiffBuilder explicitTestAndEqual = new DiffBuilder((Object)1, (Object)1, null, true);
        explicitTestAndEqual.append("letter", (Object)"X", (Object)"Y");
        MatcherAssert.assertThat((Object)explicitTestAndEqual.build().getNumberOfDiffs(), (Matcher)equalToZero);
    }

    static /* synthetic */ ToStringStyle access$000() {
        return SHORT_STYLE;
    }

    private static final class TypeTestClass
    implements Diffable<TypeTestClass> {
        private ToStringStyle style = DiffBuilderTest.access$000();
        private boolean booleanField = true;
        private boolean[] booleanArrayField = new boolean[]{true};
        private byte byteField = (byte)-1;
        private byte[] byteArrayField = new byte[]{-1};
        private char charField = (char)97;
        private char[] charArrayField = new char[]{'a'};
        private double doubleField = 1.0;
        private double[] doubleArrayField = new double[]{1.0};
        private float floatField = 1.0f;
        private float[] floatArrayField = new float[]{1.0f};
        private int intField = 1;
        private int[] intArrayField = new int[]{1};
        private long longField = 1L;
        private long[] longArrayField = new long[]{1L};
        private short shortField = 1;
        private short[] shortArrayField = new short[]{1};
        private Object objectField;
        private Object[] objectArrayField = new Object[]{null};
        private final NestedTypeTestClass nestedDiffableField = new NestedTypeTestClass();

        private TypeTestClass() {
        }

        public DiffResult<TypeTestClass> diff(TypeTestClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, this.style).append("boolean", this.booleanField, obj.booleanField).append("booleanArray", this.booleanArrayField, obj.booleanArrayField).append("byte", this.byteField, obj.byteField).append("byteArray", this.byteArrayField, obj.byteArrayField).append("char", this.charField, obj.charField).append("charArray", this.charArrayField, obj.charArrayField).append("double", this.doubleField, obj.doubleField).append("doubleArray", this.doubleArrayField, obj.doubleArrayField).append("float", this.floatField, obj.floatField).append("floatArray", this.floatArrayField, obj.floatArrayField).append("int", this.intField, obj.intField).append("intArray", this.intArrayField, obj.intArrayField).append("long", this.longField, obj.longField).append("longArray", this.longArrayField, obj.longArrayField).append("short", this.shortField, obj.shortField).append("shortArray", this.shortArrayField, obj.shortArrayField).append("objectField", this.objectField, obj.objectField).append("objectArrayField", this.objectArrayField, obj.objectArrayField).append("nestedDiffableField", this.nestedDiffableField.diff(obj.nestedDiffableField)).build();
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
        }

        static /* synthetic */ boolean[] access$402(TypeTestClass x0, boolean[] x1) {
            x0.booleanArrayField = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(TypeTestClass x0, byte[] x1) {
            x0.byteArrayField = x1;
            return x1;
        }

        static /* synthetic */ char[] access$802(TypeTestClass x0, char[] x1) {
            x0.charArrayField = x1;
            return x1;
        }

        static /* synthetic */ double[] access$1102(TypeTestClass x0, double[] x1) {
            x0.doubleArrayField = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1302(TypeTestClass x0, float[] x1) {
            x0.floatArrayField = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1402(TypeTestClass x0, int[] x1) {
            x0.intArrayField = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1602(TypeTestClass x0, long[] x1) {
            x0.longArrayField = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$2002(TypeTestClass x0, Object[] x1) {
            x0.objectArrayField = x1;
            return x1;
        }

        static /* synthetic */ short[] access$2202(TypeTestClass x0, short[] x1) {
            x0.shortArrayField = x1;
            return x1;
        }
    }

    private static class NestedTypeTestClass
    implements Diffable<NestedTypeTestClass> {
        private final ToStringStyle style = DiffBuilderTest.access$000();
        private boolean booleanField = true;

        private NestedTypeTestClass() {
        }

        public DiffResult<NestedTypeTestClass> diff(NestedTypeTestClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, this.style).append("boolean", this.booleanField, obj.booleanField).build();
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
        }
    }
}

