/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.commons.lang3.exception.CustomUncheckedException;
import org.apache.commons.lang3.function.MethodFixtures;
import org.apache.commons.lang3.function.MethodInvokers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MethodInvokersBiFunctionTest
extends MethodFixtures {
    @Test
    public void testApply1Arg() throws NoSuchMethodException, SecurityException {
        BiFunction func = MethodInvokers.asBiFunction((Method)MethodInvokersBiFunctionTest.getMethodForGetString1Arg());
        Assertions.assertEquals((Object)INSTANCE.getString1Arg("A"), func.apply(INSTANCE, "A"));
    }

    @Test
    public void testApply1ArgThrowsUnchecked() throws NoSuchMethodException, SecurityException {
        BiFunction func = MethodInvokers.asBiFunction((Method)MethodInvokersBiFunctionTest.getMethodForGetString1ArgThrowsUnchecked());
        Assertions.assertThrows(CustomUncheckedException.class, () -> {
            String cfr_ignored_0 = (String)func.apply(INSTANCE, "A");
        });
    }

    @Test
    public void testConstructorForNull() throws SecurityException {
        Assertions.assertThrows(NullPointerException.class, () -> MethodInvokers.asBiFunction(null));
    }

    @Test
    public void testFullExample() throws SecurityException, ReflectiveOperationException {
        Method method = String.class.getMethod("charAt", Integer.TYPE);
        BiFunction function = MethodInvokers.asBiFunction((Method)method);
        Assertions.assertEquals((char)'C', (Character)((Character)function.apply("ABC", 2)));
    }

    @Test
    public void testToString() throws SecurityException, ReflectiveOperationException {
        Assertions.assertFalse((boolean)MethodInvokers.asBiFunction((Method)MethodInvokersBiFunctionTest.getMethodForGetString1Arg()).toString().isEmpty());
    }
}

