/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventCountCircuitBreakerTest
extends AbstractLangTest {
    private static final int OPENING_THRESHOLD = 10;
    private static final int CLOSING_THRESHOLD = 5;
    private static final long NANO_FACTOR = 1000000000L;

    @Test
    public void testIntervalCalculation() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS, 5, 2L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((long)1000000000L, (long)breaker.getOpeningInterval(), (String)"Wrong opening interval");
        Assertions.assertEquals((long)2000000L, (long)breaker.getClosingInterval(), (String)"Wrong closing interval");
    }

    @Test
    public void testDefaultClosingInterval() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS, 5);
        Assertions.assertEquals((long)1000000000L, (long)breaker.getClosingInterval(), (String)"Wrong closing interval");
    }

    @Test
    public void testDefaultClosingThreshold() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)1000000000L, (long)breaker.getClosingInterval(), (String)"Wrong closing interval");
        Assertions.assertEquals((int)10, (int)breaker.getClosingThreshold(), (String)"Wrong closing threshold");
    }

    @Test
    public void testInitiallyClosed() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)breaker.isOpen(), (String)"Open");
        Assertions.assertTrue((boolean)breaker.isClosed(), (String)"Not closed");
    }

    @Test
    public void testNow() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        long nowNanos = breaker.nanoTime();
        long deltaNanos = Math.abs(System.nanoTime() - nowNanos);
        Assertions.assertTrue((deltaNanos < 100000L ? 1 : 0) != 0, (String)String.format("Delta %,d ns to current time too large", deltaNanos));
    }

    @Test
    public void testNotOpeningUnderThreshold() {
        long startTime = 1000L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < 9; ++i) {
            Assertions.assertTrue((boolean)breaker.at(startTime).incrementAndCheckState(), (String)"In open state");
            ++startTime;
        }
        Assertions.assertTrue((boolean)breaker.isClosed(), (String)"Not closed");
    }

    @Test
    public void testNotOpeningCheckIntervalExceeded() {
        long startTime = 0L;
        long timeIncrement = 150000000L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < 50; ++i) {
            Assertions.assertTrue((boolean)breaker.at(startTime).incrementAndCheckState(), (String)"In open state");
            startTime += 150000000L;
        }
        Assertions.assertTrue((boolean)breaker.isClosed(), (String)"Not closed");
    }

    @Test
    public void testOpeningWhenThresholdReached() {
        long startTime = 0L;
        long timeIncrement = 99999999L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        boolean open = false;
        for (int i = 0; i < 11; ++i) {
            open = !breaker.at(startTime).incrementAndCheckState();
            startTime += 99999999L;
        }
        Assertions.assertTrue((boolean)open, (String)"Not open");
        Assertions.assertFalse((boolean)breaker.isClosed(), (String)"Closed");
    }

    @Test
    public void testOpeningWhenThresholdReachedThroughBatch() {
        long timeIncrement = 99999999L;
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 1L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long startTime = 1099999989L;
        boolean open = !breaker.at(1099999989L).incrementAndCheckState(11);
        Assertions.assertTrue((boolean)open, (String)"Not open");
        Assertions.assertFalse((boolean)breaker.isClosed(), (String)"Closed");
    }

    @Test
    public void testNotClosingOverThreshold() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 10L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long startTime = 0L;
        breaker.open();
        for (int i = 0; i <= 5; ++i) {
            Assertions.assertFalse((boolean)breaker.at(startTime).incrementAndCheckState(), (String)"Not open");
            startTime += 1000L;
        }
        Assertions.assertFalse((boolean)breaker.at(startTime + 1000000000L).incrementAndCheckState(), (String)"Closed in new interval");
        Assertions.assertTrue((boolean)breaker.isOpen(), (String)"Not open at end");
    }

    @Test
    public void testClosingWhenThresholdReached() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 10L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        breaker.open();
        breaker.at(1000L).incrementAndCheckState();
        Assertions.assertFalse((boolean)breaker.at(2000L).checkState(), (String)"Already closed");
        Assertions.assertFalse((boolean)breaker.at(1000000000L).checkState(), (String)"Closed at interval end");
        Assertions.assertTrue((boolean)breaker.at(1000000001L).checkState(), (String)"Not closed after interval end");
        Assertions.assertTrue((boolean)breaker.isClosed(), (String)"Not closed at end");
    }

    @Test
    public void testOpenStartsNewCheckInterval() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        breaker.at(999999000L).open();
        Assertions.assertTrue((boolean)breaker.isOpen(), (String)"Not open");
        Assertions.assertFalse((boolean)breaker.at(1000000100L).checkState(), (String)"Already closed");
    }

    @Test
    public void testAutomaticOpenStartsNewCheckInterval() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long time = 10000000000L;
        for (int i = 0; i <= 10; ++i) {
            breaker.at(time++).incrementAndCheckState();
        }
        Assertions.assertTrue((boolean)breaker.isOpen(), (String)"Not open");
        Assertions.assertFalse((boolean)breaker.at(time += 999999000L).incrementAndCheckState(), (String)"Already closed");
        Assertions.assertTrue((boolean)breaker.at(time += 1001L).checkState(), (String)"Not closed in time interval");
    }

    @Test
    public void testClose() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        long time = 0L;
        int i = 0;
        while (i <= 10) {
            breaker.at(time).incrementAndCheckState();
            ++i;
            time += 1000L;
        }
        Assertions.assertTrue((boolean)breaker.isOpen(), (String)"Not open");
        breaker.close();
        Assertions.assertTrue((boolean)breaker.isClosed(), (String)"Not closed");
        Assertions.assertTrue((boolean)breaker.at(time + 1000L).incrementAndCheckState(), (String)"Open again");
    }

    @Test
    public void testChangeEvents() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        breaker.open();
        breaker.close();
        listener.verify(Boolean.TRUE, Boolean.FALSE);
    }

    @Test
    public void testRemoveChangeListener() {
        EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        breaker.open();
        breaker.removeChangeListener((PropertyChangeListener)listener);
        breaker.close();
        listener.verify(Boolean.TRUE);
    }

    @Test
    public void testStateTransitionGuarded() throws InterruptedException {
        final EventCountCircuitBreaker breaker = new EventCountCircuitBreaker(10, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener(breaker);
        breaker.addChangeListener((PropertyChangeListener)listener);
        int threadCount = 128;
        final CountDownLatch latch = new CountDownLatch(1);
        Thread[] threads = new Thread[128];
        for (int i = 0; i < 128; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    breaker.open();
                }
            };
            threads[i].start();
        }
        latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        listener.verify(Boolean.TRUE);
    }

    @Test
    public void testChangeEventsGeneratedByAutomaticTransitions() {
        EventCountCircuitBreakerTestImpl breaker = new EventCountCircuitBreakerTestImpl(10, 2L, TimeUnit.SECONDS, 5, 1L, TimeUnit.SECONDS);
        ChangeListener listener = new ChangeListener((Object)breaker);
        breaker.addChangeListener(listener);
        long time = 0L;
        int i = 0;
        while (i <= 10) {
            breaker.at(time).incrementAndCheckState();
            ++i;
            time += 1000L;
        }
        breaker.at(1000000001L).checkState();
        breaker.at(3000000000L).checkState();
        listener.verify(Boolean.TRUE, Boolean.FALSE);
    }

    private static class ChangeListener
    implements PropertyChangeListener {
        private final Object expectedSource;
        private final List<Boolean> changedValues;

        ChangeListener(Object source) {
            this.expectedSource = source;
            this.changedValues = new ArrayList<Boolean>();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Assertions.assertEquals((Object)this.expectedSource, (Object)evt.getSource(), (String)"Wrong event source");
            Assertions.assertEquals((Object)"open", (Object)evt.getPropertyName(), (String)"Wrong property name");
            Boolean newValue = (Boolean)evt.getNewValue();
            Boolean oldValue = (Boolean)evt.getOldValue();
            Assertions.assertNotEquals((Object)newValue, (Object)oldValue, (String)"Old and new value are equal");
            this.changedValues.add(newValue);
        }

        public void verify(Boolean ... values) {
            Assertions.assertArrayEquals((Object[])values, (Object[])this.changedValues.toArray(ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY));
        }
    }

    private static class EventCountCircuitBreakerTestImpl
    extends EventCountCircuitBreaker {
        private long currentTime;

        EventCountCircuitBreakerTestImpl(int openingThreshold, long openingInterval, TimeUnit openingUnit, int closingThreshold, long closingInterval, TimeUnit closingUnit) {
            super(openingThreshold, openingInterval, openingUnit, closingThreshold, closingInterval, closingUnit);
        }

        public EventCountCircuitBreakerTestImpl at(long time) {
            this.currentTime = time;
            return this;
        }

        long nanoTime() {
            return this.currentTime;
        }
    }
}

