/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReflectionToStringBuilderExcludeNullValuesTest
extends AbstractLangTest {
    private static final String INTEGER_FIELD_NAME = "testIntegerField";
    private static final String STRING_FIELD_NAME = "testStringField";
    private final TestFixture BOTH_NON_NULL = new TestFixture(0, "str");
    private final TestFixture FIRST_NULL = new TestFixture(null, "str");
    private final TestFixture SECOND_NULL = new TestFixture(0, null);
    private final TestFixture BOTH_NULL = new TestFixture(null, null);

    @Test
    public void test_NonExclude() {
        String toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NON_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.FIRST_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.SECOND_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_excludeNull() {
        String toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NON_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.FIRST_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.SECOND_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOption() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NON_NULL, null, null, null, false, false, true);
        Assertions.assertTrue((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.FIRST_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.SECOND_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOptionNormal() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, false);
        Assertions.assertFalse((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        ReflectionToStringBuilder oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL);
        toString = oldBuilder.toString();
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false);
        toString = oldBuilder.toString();
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null);
        toString = oldBuilder.toString();
        Assertions.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOption_ExcludeNull() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, false);
        builder.setExcludeNullValues(true);
        Assertions.assertTrue((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        ReflectionToStringBuilder oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL);
        oldBuilder.setExcludeNullValues(true);
        Assertions.assertTrue((boolean)oldBuilder.isExcludeNullValues());
        toString = oldBuilder.toString();
        Assertions.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assertions.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
    }

    static class TestFixture {
        private final Integer testIntegerField;
        private final String testStringField;

        TestFixture(Integer a, String b) {
            this.testIntegerField = a;
            this.testStringField = b;
        }
    }
}

